/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.repl;

import convex.api.Convex;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.gui.components.AbstractGUI;
import convex.gui.components.ConnectPanel;
import convex.gui.keys.KeyRingPanel;
import convex.gui.keys.UnlockWalletDialog;
import convex.gui.repl.REPLPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REPLClient
extends AbstractGUI {
    private static final Logger log = LoggerFactory.getLogger((String)REPLClient.class.getName());
    public static long maxBlock = 0L;
    protected Convex convex = null;
    public JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();
    public REPLPanel replPanel;

    public static void main(String[] args) throws IOException, TimeoutException {
        log.info("Starting Convex Client");
        Convex convex = ConnectPanel.tryConnect(null, "Connect to Convex");
        if (convex == null) {
            System.exit(1);
        }
        REPLClient gui = new REPLClient(convex);
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }

    public REPLClient(Convex convex) {
        super("Convex Terminal");
        this.setLayout(new BorderLayout());
        this.replPanel = new REPLPanel(convex);
        this.add((Component)this.tabs, "Center");
        this.tabs.add("REPL", this.replPanel);
        this.tabs.add("KeyRing", new KeyRingPanel());
        this.setPreferredSize(new Dimension(800, 600));
        this.convex = convex;
    }

    @Override
    public void afterRun() {
        if (this.convex.getKeyPair() == null) {
            AWalletEntry we = KeyRingPanel.findWalletEntry(this.convex);
            if (we != null) {
                if (we.isLocked()) {
                    UnlockWalletDialog.offerUnlock(this, we);
                }
                AKeyPair kp = we.getKeyPair();
                this.convex.setKeyPair(kp);
            } else {
                Toolkit.showMessge(this, "The key for this account is not in your key ring.\n\nTerminal opened in Query mode.");
            }
        }
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

