/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer.stake;

import convex.api.Convex;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.lang.Reader;
import convex.gui.components.ConvexTable;
import convex.gui.components.renderer.AccountKeyRenderer;
import convex.gui.components.renderer.AddressRenderer;
import convex.gui.components.renderer.BalanceRenderer;
import convex.gui.components.renderer.StringRenderer;
import java.util.ArrayList;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class PeerStakeTable
extends ConvexTable {
    protected Convex convex;
    DefaultTableModel tm = (DefaultTableModel)this.getModel();

    public PeerStakeTable(Convex convex) {
        super(new DefaultTableModel());
        this.convex = convex;
        this.setModel(this.tm);
        this.setAutoResizeMode(0);
        String colName = "Peer";
        this.tm.addColumn(colName);
        TableColumn col = new TableColumn(0, 300, new AccountKeyRenderer(), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        colName = "Controller";
        this.tm.addColumn(colName);
        col = new TableColumn(1, 80, new AddressRenderer(2), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        colName = "Staked Coins";
        this.tm.addColumn(colName);
        col = new TableColumn(2, 100, new BalanceRenderer(), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        colName = "Timestamp";
        this.tm.addColumn(colName);
        col = new TableColumn(3, 80, new StringRenderer(), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        colName = "Peer Stake";
        this.tm.addColumn(colName);
        col = new TableColumn(4, 100, new BalanceRenderer(), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        colName = "Del. Stake";
        this.tm.addColumn(colName);
        col = new TableColumn(5, 100, new BalanceRenderer(), null);
        col.setHeaderValue(colName);
        this.getColumnModel().addColumn(col);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.tm);
        this.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        SwingUtilities.invokeLater(() -> this.refresh());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    void refresh() {
        this.tm.setRowCount(0);
        String cs = "(mapv (fn [[pk p]] [pk  (:controller p) (:balance p)  (:timestamp p)  (get-peer-stake pk)  (get-stake pk *address*)  :FOO])(:peers *state*))";
        ACell cmd = Reader.read((String)cs);
        this.convex.query(cmd).thenAcceptAsync(r -> {
            System.err.println(r);
            AVector rows = (AVector)r.getValue();
            for (AVector row : rows) {
                this.tm.addRow(row.toArray());
            }
        });
    }
}

