/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer.stake;

import convex.api.Convex;
import convex.core.data.AccountKey;
import convex.core.data.prim.AInteger;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.DecimalAmountField;
import convex.gui.peer.stake.PeerStakeTable;
import convex.gui.utils.SymbolIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class PeerStakePanel
extends JPanel {
    protected Convex convex;

    public PeerStakePanel(Convex convex) {
        super(new BorderLayout());
        this.convex = convex;
        PeerStakeTable peerTable = new PeerStakeTable(convex);
        this.add((Component)new JScrollPane(peerTable), "Center");
        ActionPanel ap = new ActionPanel();
        this.add((Component)ap, "South");
        ap.add(new ActionButton("Refresh", 58837, e -> peerTable.refresh()));
        ap.add(new ActionButton("Set Stake...", 62940, e -> {
            int row = peerTable.getSelectedRow();
            if (row < 0) {
                JOptionPane.showMessageDialog(this, "Select a peer to set stake on");
                return;
            }
            Object val = peerTable.getValueAt(row, 0);
            AccountKey peerKey = AccountKey.parse((Object)val);
            if (peerKey != null) {
                Object stk = JOptionPane.showInputDialog(this, "Enter desired stake for peer " + String.valueOf(peerKey), "Set Peer Stake...", 3, SymbolIcon.get(62830), null, "0.0");
                if (!(stk instanceof String)) {
                    return;
                }
                AInteger amt = DecimalAmountField.parse((String)stk, 9, true);
                if (amt == null) {
                    JOptionPane.showMessageDialog(this, "Input amount not valid. Must be a qantity in Convex Gold, e.g. '1000.01' ");
                    return;
                }
                convex.transact("(set-stake " + String.valueOf(peerKey) + " " + String.valueOf(amt) + ")").thenAcceptAsync(r -> {
                    if (r.isError()) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Stake setting failed: " + String.valueOf(r), "Staking problem", 0));
                    }
                    peerTable.refresh();
                });
            }
        }));
    }
}

