/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer;

import convex.core.cvm.State;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.models.TorusTableModel;
import convex.gui.peer.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TorusPanel
extends JPanel {
    TorusTableModel tableModel;
    JTable table;

    public TorusPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout());
        manager.getStateModel().addPropertyChangeListener(pc -> {
            State newState = (State)pc.getNewValue();
            this.tableModel.setState(newState);
        });
        this.tableModel = new TorusTableModel(manager.getLatestState());
        this.table = new JTable(this.tableModel);
        this.table.setFont(Toolkit.MONO_FONT);
        this.table.getTableHeader().setFont(Toolkit.MONO_FONT.deriveFont(1));
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        TableColumnModel columnMondel = this.table.getColumnModel();
        columnMondel.getColumn(0).setCellRenderer(leftRenderer);
        columnMondel.getColumn(0).setPreferredWidth(80);
        columnMondel.getColumn(1).setCellRenderer(leftRenderer);
        columnMondel.getColumn(1).setPreferredWidth(80);
        columnMondel.getColumn(2).setCellRenderer(rightRenderer);
        columnMondel.getColumn(2).setPreferredWidth(160);
        columnMondel.getColumn(3).setCellRenderer(rightRenderer);
        columnMondel.getColumn(3).setPreferredWidth(160);
        columnMondel.getColumn(4).setCellRenderer(rightRenderer);
        columnMondel.getColumn(4).setPreferredWidth(160);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int r = TorusPanel.this.table.rowAtPoint(e.getPoint());
                if (r >= 0 && r < TorusPanel.this.table.getRowCount()) {
                    TorusPanel.this.table.setRowSelectionInterval(r, r);
                } else {
                    TorusPanel.this.table.clearSelection();
                }
            }
        });
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        ActionButton btnCopy = new ActionButton("New Token", 57669, e -> {});
        actionPanel.add(btnCopy);
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(null);
        this.add((Component)scrollPane, "Center");
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }
}

