/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer;

import convex.api.ConvexLocal;
import convex.core.init.Init;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.ScrollyList;
import convex.gui.peer.PeerComponent;
import convex.gui.peer.PeerGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerListPanel
extends JPanel {
    JPanel peersPanel;
    JPanel peerViewPanel;
    JScrollPane scrollPane;
    PeerGUI manager;
    static final Logger log = LoggerFactory.getLogger((String)ServerListPanel.class.getName());

    public List<ConvexLocal> getPeerViews() {
        DefaultListModel<ConvexLocal> peerList = this.manager.getPeerList();
        ArrayList<ConvexLocal> al = new ArrayList<ConvexLocal>();
        int n = peerList.getSize();
        for (int i = 0; i < n; ++i) {
            ConvexLocal p = peerList.getElementAt(i);
            al.add(p);
        }
        return al;
    }

    public ServerListPanel(PeerGUI manager) {
        this.manager = manager;
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel toolBar = new ActionPanel();
        this.add((Component)toolBar, "South");
        ActionButton btnLaunch = new ActionButton("Launch!", 60315, e -> {
            ConvexLocal convex = manager.getDefaultConvex();
            manager.launchExtraPeer(convex);
        });
        btnLaunch.setToolTipText("Launch an extra peer when running a local network. Allocates some stake from genesis peer controller account.");
        if (!Init.GENESIS_PEER_ADDRESS.equals(manager.getDefaultConvex().getAddress())) {
            btnLaunch.setEnabled(false);
        }
        toolBar.add(btnLaunch);
        ScrollyList<ConvexLocal> scrollyList = new ScrollyList<ConvexLocal>(manager.getPeerList(), peer -> new PeerComponent((ConvexLocal)peer));
        this.add(scrollyList, "Center");
    }
}

