/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.keys;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.data.AArrayBlob;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.DropdownMenu;
import convex.gui.components.Identicon;
import convex.gui.keys.KeyRingPanel;
import convex.gui.keys.UnlockWalletDialog;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletComponent
extends BaseListComponent {
    private static final Logger log = LoggerFactory.getLogger((String)WalletComponent.class.getName());
    JButton lockButton;
    JButton replButton;
    AWalletEntry walletEntry;
    JPanel buttons;
    private CodeLabel infoLabel;

    public WalletComponent(AWalletEntry initialWalletEntry) {
        this.walletEntry = initialWalletEntry;
        this.setLayout((LayoutManager)new MigLayout("aligny center"));
        Identicon identicon = new Identicon((AArrayBlob)this.walletEntry.getPublicKey(), Toolkit.IDENTICON_SIZE * 2);
        JPanel idPanel = new JPanel();
        idPanel.add(identicon);
        this.add(idPanel);
        JPanel cPanel = new JPanel();
        cPanel.setLayout((LayoutManager)new MigLayout());
        this.infoLabel = new CodeLabel(this.getInfoString());
        this.infoLabel.setFont(Toolkit.SMALL_MONO_FONT);
        cPanel.add((Component)this.infoLabel, "dock center");
        this.add(cPanel);
        this.buttons = new JPanel();
        this.buttons.setLayout((LayoutManager)new MigLayout());
        this.lockButton = new JButton("");
        this.buttons.add(this.lockButton);
        this.lockButton.addActionListener(e -> {
            if (this.walletEntry.isLocked()) {
                UnlockWalletDialog.offerUnlock(this, this.walletEntry);
            } else {
                try {
                    if (this.walletEntry.needsLockPassword()) {
                        String s = JOptionPane.showInputDialog(this, (Object)"Enter lock password");
                        if (s != null) {
                            this.walletEntry.lock(s.toCharArray());
                        }
                    } else {
                        this.walletEntry.lock();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            this.doUpdate();
        });
        JPopupMenu menu = new JPopupMenu();
        JMenuItem m2 = new JMenuItem("Show seed...", Toolkit.menuIcon(59636));
        m2.addActionListener(this::showSeed);
        menu.add(m2);
        JMenuItem m3 = new JMenuItem("Remove...", Toolkit.menuIcon(59506));
        m3.addActionListener(e -> {
            boolean shouldDelete = false;
            if (this.walletEntry.getSource().contains("KeyStore")) {
                shouldDelete = true;
            } else {
                int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this keypair from your keyring before saving it?", "Confirm Delete", 2);
                if (confirm == 0) {
                    shouldDelete = true;
                }
            }
            if (shouldDelete) {
                KeyRingPanel.getListModel().removeElement(this.walletEntry);
            }
        });
        menu.add(m3);
        JMenuItem m4 = new JMenuItem("Save to KeyStore...", Toolkit.menuIcon(57697));
        m4.addActionListener(e -> KeyRingPanel.saveKey(this, this.walletEntry));
        menu.add(m4);
        DropdownMenu menuButton = new DropdownMenu(menu);
        menuButton.setToolTipText("Settings and special actions for this key");
        this.buttons.add(menuButton);
        this.add((Component)this.buttons, "dock east");
        this.doUpdate();
    }

    private void showSeed(ActionEvent e) {
        if (this.walletEntry.isLocked() && !UnlockWalletDialog.offerUnlock(this, this.walletEntry)) {
            return;
        }
        AKeyPair kp = this.walletEntry.getKeyPair();
        if (kp != null) {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("wrap 1", "[200]"));
            panel.add((Component)new Identicon((AArrayBlob)kp.getAccountKey(), Toolkit.IDENTICON_SIZE_LARGE), "align center");
            panel.add(Toolkit.withTitledBorder("Ed25519 Private Seed", new CodeLabel(kp.getSeed().toString())));
            panel.add((Component)Toolkit.makeNote("WARNING: keep this private, it can be used to control your account(s)"), "grow");
            panel.setBorder(Toolkit.createDialogBorder());
            JOptionPane.showMessageDialog(this, panel, "Ed25519 Private Seed", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Keypair is locked, cannot access seed", "Warning", 2);
        }
    }

    private void doUpdate() {
        this.resetTooltipText(this.lockButton);
        this.infoLabel.setText(this.getInfoString());
        ImageIcon icon = this.walletEntry.isLocked() ? Toolkit.LOCKED_ICON : Toolkit.UNLOCKED_ICON;
        this.lockButton.setIcon(icon);
        this.lockButton.setForeground(Color.WHITE);
    }

    private void resetTooltipText(JComponent b) {
        if (this.walletEntry.isLocked()) {
            b.setToolTipText("Currently locked. Press to unlock.");
        } else {
            b.setToolTipText("Currently unlocked. Press to lock.");
        }
    }

    private String getInfoString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Public Key: " + String.valueOf(this.walletEntry.getPublicKey()) + "\n");
        sb.append("Source:     " + this.walletEntry.getSource());
        return sb.toString();
    }
}

