/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.etch;

import convex.core.store.Stores;
import convex.etch.EtchStore;
import convex.gui.components.AbstractGUI;
import convex.gui.etch.DatabasePanel;
import convex.gui.models.StateModel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtchExplorer
extends AbstractGUI {
    public static final Logger log = LoggerFactory.getLogger((String)EtchExplorer.class.getName());
    public static long maxBlock = 0L;
    JPanel panel = new JPanel();
    private static StateModel<EtchStore> etchState = StateModel.create((EtchStore)Stores.getGlobalStore());
    DatabasePanel homePanel = new DatabasePanel(this);
    JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();

    public static void main(String[] args) {
        Toolkit.init();
        EtchExplorer gui = new EtchExplorer();
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }

    public EtchExplorer() {
        super("Etch Explorer");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Database", this.homePanel);
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    public StateModel<EtchStore> getEtchState() {
        return etchState;
    }

    public EtchStore getStore() {
        return etchState.getValue();
    }

    public void setStore(EtchStore newEtch) {
        EtchStore e = etchState.getValue();
        e.close();
        etchState.setValue(newEtch);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

