/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.dlfs.DLPath;
import convex.gui.components.Toast;
import convex.gui.dlfs.BrowserUtils;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class FileList
extends JList<Path> {
    private Path directory;
    DefaultListModel<Path> model;

    public FileList(Path initialDir, final Consumer<Path> obDoubleClick) {
        this.directory = initialDir;
        this.model = new DefaultListModel();
        this.setCellRenderer(new Renderer());
        this.setDragEnabled(true);
        this.setModel(this.model);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Path p;
                if (e.getClickCount() == 2 && (p = FileList.this.getSelectedPath()) != null && Files.isDirectory(p, new LinkOption[0])) {
                    obDoubleClick.accept(p);
                }
            }
        });
        Toolkit.addPopupMenu(this, new FileContextMenu());
    }

    public void refreshList() {
        this.setDirectory(this.directory);
    }

    protected Path getSelectedPath() {
        Object o = this.getSelectedValue();
        if (o instanceof Path) {
            return (Path)o;
        }
        return null;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void setDirectory(Path newPath) {
        this.directory = newPath;
        this.model.removeAllElements();
        if (!(this.directory instanceof DLPath)) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.directory);){
            for (Path path : stream) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                this.model.addElement(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Renderer
    extends DefaultListCellRenderer {
        @Override
        public Renderer getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Path) {
                Path p = (Path)value;
                this.setIcon(BrowserUtils.getFileIcon(p));
                this.setText(p.getFileName().toString());
            }
            return this;
        }
    }

    public class FileContextMenu
    extends JPopupMenu {
        public FileContextMenu() {
            this.add(Toolkit.makeMenu("Delete", () -> {
                try {
                    Path p = FileList.this.getSelectedPath();
                    System.out.println("Deleting:" + String.valueOf(p));
                    if (p != null) {
                        Files.delete(p);
                    }
                    FileList.this.refreshList();
                }
                catch (IOException e) {
                    Toast.display(null, "Can't delete file!", Color.ORANGE);
                    e.printStackTrace();
                }
            }));
        }
    }
}

