/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.gui.dlfs.BrowserUtils;
import convex.gui.dlfs.DLFSPanel;
import convex.gui.dlfs.DirectoryTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public abstract class DnDTransferHandler
extends TransferHandler {
    private final DLFSPanel dlfsPanel;

    public DnDTransferHandler(DLFSPanel dlfsPanel) {
        this.dlfsPanel = dlfsPanel;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        Transferable tf = support.getTransferable();
        Path targetDir = this.getTargetDirectory(support);
        System.out.println("Dropping to: " + String.valueOf(targetDir));
        try {
            List files = (List)tf.getTransferData(DataFlavor.javaFileListFlavor);
            if (files == null || files.isEmpty()) {
                return false;
            }
            boolean copied = BrowserUtils.copyFiles((JComponent)support.getComponent(), files, targetDir);
            this.dlfsPanel.setSelectedPath((Path)this.dlfsPanel.getSelectedPath());
            return copied;
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Path getTargetDirectory(TransferHandler.TransferSupport support) {
        JTree.DropLocation dl;
        TreePath treePath;
        Path targetDir = this.getTargetPath();
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        if (dropLocation instanceof JTree.DropLocation && (treePath = (dl = (JTree.DropLocation)dropLocation).getPath()) != null) {
            DirectoryTree.Node parent = (DirectoryTree.Node)treePath.getLastPathComponent();
            System.out.println("Parent: " + String.valueOf(parent));
            targetDir = parent.getFilePath();
        }
        return targetDir;
    }

    protected abstract Path getTargetPath();
}

