/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.dlfs.DLFS;
import convex.dlfs.DLFileSystem;
import convex.dlfs.DLPath;
import convex.gui.components.AbstractGUI;
import convex.gui.dlfs.DLFSPanel;
import convex.gui.state.StateExplorer;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import net.miginfocom.swing.MigLayout;

public class DLFSBrowser
extends AbstractGUI {
    protected DLFileSystem drive;
    public static ArrayList<DLFileSystem> allDrives = new ArrayList();
    public JMenuBar menuBar = new JMenuBar();
    public JMenu fileMenu = new JMenu("File");
    public JMenu driveMenu = new JMenu("Drive");
    public JMenu helpMenu = new JMenu("Help");
    protected DLFSPanel panel;

    public DLFSBrowser(DLFileSystem drive) {
        super("Data Lattice");
        DLFS.provider().fileSystems.put((Object)"drive", (Object)drive);
        allDrives.add(drive);
        this.setLayout((LayoutManager)new MigLayout());
        this.drive = drive;
        this.panel = new DLFSPanel(drive);
        this.add((Component)this.panel, "dock center");
        this.fileMenu.add(Toolkit.makeMenu("Explore Node...", () -> {
            DLPath p = this.panel.getSelectedPath();
            if (p instanceof DLPath) {
                AVector node = drive.getNode(p);
                if (node != null) {
                    StateExplorer.explore((ACell)node);
                } else {
                    StateExplorer.explore((ACell)drive.getNode(drive.getRoot()));
                }
            }
            this.panel.refreshView();
        }));
        this.fileMenu.add(Toolkit.makeMenu("Delete", () -> {
            DLPath p = this.panel.getSelectedPath();
            try {
                Files.deleteIfExists((Path)p);
            }
            catch (IOException e) {
                System.out.println("Can't delete " + String.valueOf(p) + " : " + e.getMessage());
            }
            this.panel.refreshView();
        }));
        this.menuBar.add(this.fileMenu);
        this.driveMenu.add(Toolkit.makeMenu("Clone", () -> new DLFSBrowser(drive.clone()).run()));
        this.driveMenu.add(Toolkit.makeMenu("Sync", () -> {
            for (DLFileSystem other : allDrives) {
                if (other == drive) continue;
                System.out.println("Replicating!!");
                drive.replicate(other);
            }
            this.panel.refreshView();
        }));
        this.menuBar.add(this.driveMenu);
        this.menuBar.add(Toolkit.makeMenu("Sync!", () -> {
            for (DLFileSystem other : allDrives) {
                if (other == drive) continue;
                System.out.println("Replicating!!");
                drive.replicate(other);
            }
            this.panel.refreshView();
        }));
    }

    @Override
    public void afterRun() {
        this.getFrame().setJMenuBar(this.menuBar);
    }

    public DLFileSystem getDrive() {
        return this.drive;
    }

    public DLFSBrowser() {
        this(DLFSBrowser.createDemoDrive());
    }

    public static DLFileSystem createDemoDrive() {
        DLFileSystem drive = DLFS.createLocal();
        drive.updateTimestamp();
        DLPath p = drive.getRoot();
        try {
            Files.createDirectory(p.resolve("training"), new FileAttribute[0]);
            Files.createDirectory(p.resolve("models"), new FileAttribute[0]);
            Files.createDirectory(p.resolve("input"), new FileAttribute[0]);
            Files.createDirectory(p.resolve("provenance"), new FileAttribute[0]);
            Files.createDirectory(p.resolve("pytools"), new FileAttribute[0]);
            Files.createDirectory(p.resolve("cuda"), new FileAttribute[0]);
            Files.createFile(p.resolve("models/ace1.tensor"), new FileAttribute[0]);
            Files.createFile(p.resolve("models/ace2.tensor"), new FileAttribute[0]);
            Files.createDirectories(p.resolve("models/old"), new FileAttribute[0]);
            Files.createDirectories(p.resolve("models/experimental"), new FileAttribute[0]);
            Files.createFile(p.resolve("tombstone"), new FileAttribute[0]);
            Files.delete(p.resolve("tombstone"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return drive;
    }

    public static void main(String[] args) {
        Toolkit.init();
        DLFSBrowser gui = new DLFSBrowser();
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

