/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.account;

import convex.api.Convex;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.data.AArrayBlob;
import convex.core.data.AccountKey;
import convex.core.data.Blobs;
import convex.core.util.Utils;
import convex.gui.components.CodeLabel;
import convex.gui.components.Identicon;
import convex.gui.keys.KeyRingPanel;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.NoSuchElementException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.miginfocom.swing.MigLayout;

public class KeyPairCombo
extends JComboBox<AWalletEntry> {
    private static AKeyPair TEMP_KEYPAIR = AKeyPair.createSeeded((long)1337L);
    private static HotWalletEntry PROTOTYPE = HotWalletEntry.create((AKeyPair)TEMP_KEYPAIR, (String)"Prototype key");

    public KeyPairCombo(ComboBoxModel<AWalletEntry> model) {
        this.setModel(model);
        this.setRenderer(new KeyPairRenderer());
        this.setFocusable(false);
    }

    @Override
    public AWalletEntry getPrototypeDisplayValue() {
        return PROTOTYPE;
    }

    public static void main(String ... args) {
        Toolkit.init();
        JPanel p = new JPanel();
        p.setLayout((LayoutManager)new MigLayout("insets 20 20 20 20, wrap 1"));
        KeyPairModel model = new KeyPairModel();
        model.addElement((AWalletEntry)HotWalletEntry.create((AKeyPair)AKeyPair.generate(), (String)"Test key"));
        KeyPairCombo kpCombo = new KeyPairCombo(model);
        p.add(kpCombo);
        CodeLabel sel = new CodeLabel("Nothing selected");
        p.add(sel);
        kpCombo.addItemListener(e -> {
            Object o = kpCombo.getSelectedItem();
            sel.setText(String.valueOf(o) + " : " + Utils.getClassName((Object)o));
        });
        Toolkit.showMainFrame(p);
    }

    public AWalletEntry getWalletEntry() {
        Object a = this.getModel().getSelectedItem();
        return (AWalletEntry)a;
    }

    public static KeyPairCombo forConvex(Convex convex) {
        AKeyPair kp = convex.getKeyPair();
        return KeyPairCombo.create(kp);
    }

    public static KeyPairCombo create() {
        KeyPairModel model = new KeyPairModel();
        try {
            model.setSelectedItem(model.underlying.firstElement());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new KeyPairCombo(model);
    }

    public static KeyPairCombo create(AKeyPair kp) {
        KeyPairModel model = new KeyPairModel();
        if (kp != null) {
            AccountKey publicKey = kp.getAccountKey();
            AWalletEntry we = KeyRingPanel.getKeyRingEntry(publicKey);
            if (we == null) {
                we = new HotWalletEntry(kp, null);
            }
            model.setSelectedItem(we);
        }
        return new KeyPairCombo(model);
    }

    public class KeyPairRenderer
    extends JLabel
    implements ListCellRenderer<AWalletEntry> {
        public KeyPairRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AWalletEntry> list, AWalletEntry value, int index, boolean isSelected, boolean cellHasFocus) {
            AWalletEntry entry = value;
            if (entry != null) {
                AccountKey pubKey = entry.getPublicKey();
                this.setText("0x" + pubKey.toChecksumHex().substring(0, 16) + "...");
                this.setIcon(Identicon.createIcon(entry.getIdenticonData(), 21));
            } else {
                this.setText("<no key pair set>");
                this.setIcon(Identicon.createIcon((AArrayBlob)Blobs.empty(), 21));
            }
            return this;
        }
    }

    public static class KeyPairModel
    implements ComboBoxModel<AWalletEntry> {
        private DefaultListModel<AWalletEntry> underlying;
        private AWalletEntry selected;

        public KeyPairModel(DefaultListModel<AWalletEntry> underlying) {
            this.underlying = underlying;
        }

        public KeyPairModel() {
            this(KeyRingPanel.getListModel());
        }

        @Override
        public int getSize() {
            return this.underlying.getSize() + 1;
        }

        @Override
        public AWalletEntry getElementAt(int index) {
            int n = this.underlying.getSize();
            if (index >= n) {
                return null;
            }
            return this.underlying.getElementAt(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.underlying.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.underlying.removeListDataListener(l);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = (AWalletEntry)anItem;
            ListDataListener[] listeners = this.underlying.getListDataListeners();
            ListDataEvent e = new ListDataEvent(this, 0, 0, 0);
            for (ListDataListener l : listeners) {
                l.contentsChanged(e);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        public void addElement(AWalletEntry entry) {
            this.underlying.addElement(entry);
        }
    }
}

