/*
 * Decompiled with CFR 0.152.
 */
package convex.gui;

import convex.api.Convex;
import convex.gui.components.AbstractGUI;
import convex.gui.components.ActionPanel;
import convex.gui.components.ConnectPanel;
import convex.gui.dlfs.DLFSBrowser;
import convex.gui.panels.HomePanel;
import convex.gui.peer.PeerLaunchDialog;
import convex.gui.repl.REPLClient;
import convex.gui.tools.HackerTools;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.WalletApp;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MainGUI
extends AbstractGUI {
    public MainGUI() {
        super("Convex Desktop");
        MigLayout layout = new MigLayout("wrap 1", "[fill]");
        this.setLayout((LayoutManager)layout);
        this.add((Component)new HomePanel(), "dock center");
        ActionPanel actionPanel = new ActionPanel();
        actionPanel.setLayout((LayoutManager)new MigLayout("center,align center,fillx"));
        JPanel wallet = this.createLaunchButton("Wallet", Toolkit.WALLET_ICON, this::launchWallet, "Open a Convex Wallet, connecting to any existing network");
        actionPanel.add(wallet);
        JPanel testNet = this.createLaunchButton("Peer Manager", Toolkit.TESTNET_ICON, this::launchTestNet, "Launch a DevNet with the Peer Manager. This gives you a test network you can use freely for testing and development purposes.");
        actionPanel.add(testNet);
        JPanel latticeFS = this.createLaunchButton("Lattice Filesystem", Toolkit.DLFS_ICON, this::launchDLFS, "Launch a DLFS file browser. EXPERIMENTAL.");
        actionPanel.add(latticeFS);
        JPanel terminal = this.createLaunchButton("Terminal", Toolkit.TERMINAL_ICON, this::launchTerminalClient, "Open a Convex REPL terminal, connecting to any existing network");
        actionPanel.add(terminal);
        JPanel hacker = this.createLaunchButton("Hacker Tools", Toolkit.HACKER_ICON, this::launchTools, "Open a set of useful tools for hackers and power users.");
        actionPanel.add(hacker);
        JPanel discord = this.createLaunchButton("Discord", Toolkit.ECOSYSTEM_ICON, this::launchDiscord, "Go to the Convex community Discord (opens web browser).");
        actionPanel.add(discord);
        JPanel www = this.createLaunchButton("Documentation", Toolkit.WWW_ICON, this::launchWebsite, "Go to the Convex docs website (opens web browser).");
        actionPanel.add(www);
        this.add((Component)actionPanel, "dock south");
    }

    public void launchDLFS() {
        new DLFSBrowser().run();
    }

    public void launchWallet() {
        Convex convex = ConnectPanel.tryConnect(this);
        if (convex != null) {
            new WalletApp(convex).run();
        }
    }

    public void launchTestNet() {
        PeerLaunchDialog.runLaunchDialog(this);
    }

    public void launchDiscord() {
        Toolkit.launchBrowser("https://discord.com/invite/xfYGq4CT7v");
    }

    public void launchTerminalClient() {
        Convex convex = ConnectPanel.tryConnect(this);
        if (convex != null) {
            new REPLClient(convex).run();
        }
    }

    public HackerTools launchTools() {
        HackerTools tools = new HackerTools();
        tools.run();
        return tools;
    }

    public void launchWebsite() {
        Toolkit.launchBrowser("https://docs.convex.world");
    }

    public JPanel createLaunchButton(String label, ImageIcon icon, Runnable cmd, String tooltip) {
        JButton butt = new JButton(icon);
        butt.addActionListener(e -> EventQueue.invokeLater(cmd));
        butt.setToolTipText(tooltip);
        JLabel lab = new JLabel(label);
        lab.setFont(Toolkit.BUTTON_FONT);
        lab.setHorizontalAlignment(0);
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("center, wrap 1", "[align center]"));
        panel.add(butt);
        panel.add(lab);
        return panel;
    }

    public static void main(String ... args) {
        MainGUI gui = new MainGUI();
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

