/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.crypto.wallet.AWalletEntry;
import convex.dlfs.DLFS;
import convex.gui.components.AbstractGUI;
import convex.gui.components.ConnectPanel;
import convex.gui.dlfs.DLFSPanel;
import convex.gui.keys.KeyRingPanel;
import convex.gui.keys.UnlockWalletDialog;
import convex.gui.panels.HomePanel;
import convex.gui.peer.stake.PeerStakePanel;
import convex.gui.utils.SymbolIcon;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.AccountOverview;
import convex.gui.wallet.FriendPanel;
import convex.gui.wallet.QRPanel;
import convex.gui.wallet.SettingsPanel;
import convex.gui.wallet.TokenListPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class WalletApp
extends AbstractGUI {
    JPanel panel = new JPanel();
    HomePanel homePanel = new HomePanel();
    JTabbedPane tabs = new JTabbedPane(2);
    protected Convex convex;
    protected static final int TAB_ICON_SIZE = Toolkit.ICON_SIZE;

    public WalletApp(Convex convex) {
        super("Convex Wallet");
        this.convex = convex;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.add((Component)new AccountOverview(convex), "dock north");
        this.addTab("Wallet", 59472, new TokenListPanel(convex));
        this.addTab("Friends", 62003, new FriendPanel(convex));
        this.addTab("Drive", 57819, new DLFSPanel(DLFS.createLocal()));
        this.addTab("Staking", 62830, new PeerStakePanel(convex));
        KeyRingPanel keyPanel = new KeyRingPanel();
        this.addTab("Keys", 59196, keyPanel);
        this.addTab("QR Code", 61958, new QRPanel(convex));
        this.addTab("Settings", 59576, new SettingsPanel(convex));
        this.add((Component)this.tabs, "dock center");
    }

    @Override
    public void afterRun() {
        if (this.convex.getKeyPair() == null) {
            AWalletEntry we = KeyRingPanel.findWalletEntry(this.convex);
            if (we != null) {
                if (we.isLocked()) {
                    UnlockWalletDialog.offerUnlock(this.homePanel, we);
                }
                this.convex.setKeyPair(we.getKeyPair());
            } else {
                Toolkit.showMessge(this, "The key for this account is not in your key ring.\n\nWallet opened in read-only mode: transactions will fail.");
            }
        }
    }

    private void addTab(String name, int iconCode, JComponent panel) {
        SymbolIcon icon = SymbolIcon.get(iconCode, TAB_ICON_SIZE);
        this.tabs.addTab("", icon, panel);
        int i = this.tabs.getTabCount() - 1;
        this.tabs.setToolTipTextAt(i, name);
        JLabel label = new JLabel();
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        label.setAlignmentX(0.0f);
        label.setToolTipText(name);
        label.setIcon(icon);
        label.setHorizontalAlignment(0);
    }

    public String getTitle() {
        return "Convex Wallet";
    }

    public static void main(String[] args) throws InterruptedException {
        Toolkit.init();
        Convex convex = ConnectPanel.tryConnect(null, "Connect to Convex");
        if (convex != null) {
            WalletApp app = new WalletApp(convex);
            app.run();
            app.waitForClose();
        }
        Thread.sleep(4000L);
        System.exit(0);
    }
}

