/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.data.prim.AInteger;
import convex.gui.components.AbstractGUI;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.BalanceLabel;
import convex.gui.components.DecimalAmountField;
import convex.gui.components.account.AddressCombo;
import convex.gui.models.ComboModel;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.TokenButton;
import convex.gui.wallet.TokenInfo;
import convex.net.IPUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TransferPanel
extends AbstractGUI {
    protected Convex convex;
    protected TokenInfo token;
    protected BalanceLabel balanceLabel;
    private DecimalAmountField amountField;
    private AddressCombo addressCombo;
    private Address address;
    private static ComboModel<Address> model = new ComboModel();
    private JPanel swapPanel;

    private TransferPanel(String title) {
        super(title);
    }

    public TransferPanel(Convex convex, TokenInfo token) {
        this("Token Transfer for account " + String.valueOf(convex.getAddress()));
        this.convex = convex;
        this.token = token;
        this.address = convex.getAddress();
        if (this.address == null) {
            throw new IllegalStateException("Must be a valid address to transfer from");
        }
        model.ensureContains(this.address);
        this.setLayout((LayoutManager)new MigLayout("fill,wrap", "[]", "[][][grow]"));
        this.setBorder(Toolkit.createDialogBorder());
        this.swapPanel = new JPanel();
        this.addTransferComponents(this.swapPanel);
        this.add((Component)this.swapPanel, "align center,span,growx");
        ActionPanel actionPanel = new ActionPanel();
        actionPanel.add(new ActionButton("Transfer!", 59699, e -> {
            try {
                Result done = this.executeTransfer();
                if (done == null) {
                    return;
                }
                if (done.isError()) {
                    JOptionPane.showMessageDialog(this, "Transfer failed!\n" + String.valueOf(done.getErrorCode()) + "\n" + String.valueOf(done.getValue()));
                } else {
                    super.closeGUI();
                }
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }));
        actionPanel.add(new ActionButton("Close", 58825, e -> super.closeGUI()));
        this.add((Component)actionPanel, "dock south");
    }

    protected void addTransferComponents(JPanel panel) {
        panel.removeAll();
        panel.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[150][grow]"));
        panel.add(new JLabel("Amount to transfer: "));
        panel.add(new TokenButton(this.token));
        this.amountField = new DecimalAmountField(this.token.getDecimals());
        this.amountField.setFont(Toolkit.BIG_FONT);
        panel.add((Component)this.amountField, "span");
        panel.add((Component)new JLabel("Balance:"), "span 2");
        this.balanceLabel = new BalanceLabel();
        this.balanceLabel.setDecimals(this.token.getDecimals());
        this.balanceLabel.setBalance(this.token.getBalance(this.convex).join());
        this.balanceLabel.setToolTipText("Current balance available in account " + String.valueOf(this.address));
        panel.add((Component)this.balanceLabel, "span");
        panel.add((Component)new JLabel("Destination account: "), "span 2");
        this.addressCombo = new AddressCombo((DefaultComboBoxModel<Address>)model);
        this.addressCombo.setFont(Toolkit.BIG_FONT);
        this.addressCombo.setToolTipText("Destination account that will receive asset after transfer");
        panel.add((Component)this.addressCombo, "span");
        this.amountField.setToolTipText("Input amount of " + this.token.getSymbol() + " to transfer to the destination account");
        panel.validate();
        panel.repaint();
    }

    protected Result executeTransfer() throws InterruptedException {
        AInteger amount = this.amountField.getAmount();
        if (amount == null) {
            JOptionPane.showMessageDialog(this, "Please specify a valid amount to transfer");
            return null;
        }
        Address target = this.addressCombo.getAddress();
        String qs = this.token.isConvex() ? "(transfer " + String.valueOf(target) + " " + String.valueOf(amount) + ")" : "(@convex.asset/transfer " + String.valueOf(target) + " [ " + String.valueOf(this.token.getID()) + " " + String.valueOf(amount) + " ])";
        System.out.println(qs);
        Result r = this.convex.transactSync(qs);
        if (!r.isError()) {
            model.ensureContains(target);
        }
        return r;
    }

    public static void main(String[] args) throws InterruptedException, IOException, TimeoutException {
        Toolkit.init();
        InetSocketAddress sa = IPUtils.toInetSocketAddress((String)"localhost:18888");
        ConvexRemote convex = Convex.connect((InetSocketAddress)sa);
        convex.setAddress(Address.create((long)11L));
        new TransferPanel((Convex)convex, TokenInfo.getFungible((Convex)convex, "currency.USDF")).run();
    }
}

