/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.data.ACell;
import convex.core.lang.Reader;
import convex.core.util.ThreadUtils;
import convex.core.util.Utils;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.ScrollyList;
import convex.gui.components.Toast;
import convex.gui.wallet.TokenComponent;
import convex.gui.wallet.TokenInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TokenListPanel
extends JPanel {
    protected ScrollyList<TokenInfo> list;
    protected Convex convex;
    static DefaultListModel<TokenInfo> model = new DefaultListModel();
    static TokenInfo defaultToken = TokenInfo.convexCoin();

    public TokenListPanel(Convex convex) {
        this.convex = convex;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.list = new ScrollyList<TokenInfo>(model, token -> new TokenComponent(convex, (TokenInfo)token));
        this.add(this.list, "dock center");
        ThreadUtils.runVirtual(() -> {
            TokenListPanel.addTokenTracking(TokenInfo.get(convex, null));
            TokenListPanel.addTokenTracking(TokenInfo.getFungible(convex, "currency.USDF"));
            TokenListPanel.addTokenTracking(TokenInfo.getFungible(convex, "currency.GBPF"));
        });
        ActionPanel ap = new ActionPanel();
        ap.add(ActionButton.build("Track Token", 57669, e -> {
            String newID = JOptionPane.showInputDialog(this, (Object)"Enter Token ID");
            if (newID == null) {
                return;
            }
            try {
                ACell tokenID = newID.isBlank() ? null : Reader.read((String)newID);
                TokenInfo token = TokenInfo.get(convex, tokenID);
                if (token == null) {
                    Toast.display((JComponent)this, "Token does not exist: " + String.valueOf(tokenID), Color.ORANGE);
                } else if (model.contains(token)) {
                    Toast.display((JComponent)this, "Token already added", Color.ORANGE);
                } else {
                    TokenListPanel.addTokenTracking(token);
                }
            }
            catch (Exception ex) {
                Toast.display((JComponent)this, "Error adding token: " + ex.getMessage(), Color.ORANGE);
            }
        }, "Add a token to the tracked token list"));
        ap.add(ActionButton.build("Refresh", 58837, e -> this.list.refreshList(), "Refresh token details and balances"));
        this.add((Component)ap, "dock south");
        ThreadUtils.runVirtual(this::updateLoop);
    }

    private static boolean addTokenTracking(TokenInfo tokenInfo) {
        if (tokenInfo == null) {
            return false;
        }
        if (model.contains(tokenInfo)) {
            return false;
        }
        model.addElement(tokenInfo);
        return true;
    }

    private void updateLoop() {
        while (true) {
            try {
                while (true) {
                    if (this.isShowing()) {
                        Component[] comps;
                        for (Component c : comps = this.list.getListComponents()) {
                            if (!(c instanceof TokenComponent) || !c.isShowing()) continue;
                            ((TokenComponent)c).refresh(this.convex);
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static TokenInfo getDefaultToken() {
        return defaultToken;
    }

    public static TokenInfo getOtherToken(TokenInfo token) {
        TokenInfo other = TokenListPanel.getDefaultToken();
        if (Utils.equals((ACell)other.getID(), (ACell)token.getID())) {
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                other = model.elementAt(i);
                if (!Utils.equals((ACell)other.getID(), (ACell)token.getID())) {
                    return other;
                }
                other = null;
            }
        }
        return other;
    }
}

