/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class TokenInfo {
    private ACell id;
    private int decimals;
    private String symbol = "???";
    static Address fungibleAddress = null;
    static Address multiAddress = null;
    static Address torusAddress = null;

    private TokenInfo(ACell tokenID) {
        this.id = tokenID;
        this.decimals = this.id == null ? 9 : 2;
    }

    public ACell getID() {
        return this.id;
    }

    public String getSymbol() {
        return this.id == null ? "CVM" : this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public static TokenInfo convexCoin() {
        return TokenInfo.forID(null);
    }

    public static TokenInfo forID(ACell tokenID) {
        TokenInfo tokenInfo = new TokenInfo(tokenID);
        return tokenInfo;
    }

    public boolean equals(Object a) {
        if (a instanceof TokenInfo) {
            return Cells.equals((ACell)this.id, (ACell)((TokenInfo)a).id);
        }
        return false;
    }

    public CompletableFuture<AInteger> getBalance(Convex convex) {
        String query = this.id == null ? "*balance*" : "(" + String.valueOf(TokenInfo.getFungibleAddress(convex)) + "/balance " + String.valueOf(this.id) + ")";
        CompletionStage cf = convex.query(query).thenApply(r -> {
            ACell val;
            if (!r.isError() && (val = r.getValue()) instanceof AInteger) {
                return (AInteger)val;
            }
            throw new RuntimeException("Error querying token balance: " + String.valueOf(r));
        });
        return cf;
    }

    public static Address getFungibleAddress(Convex convex) {
        if (fungibleAddress != null) {
            return fungibleAddress;
        }
        try {
            fungibleAddress = (Address)convex.resolve("convex.fungible").get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fungibleAddress;
    }

    public static Address getMultiAddress(Convex convex) {
        if (multiAddress != null) {
            return multiAddress;
        }
        try {
            multiAddress = (Address)convex.resolve("asset.multi-token").get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return multiAddress;
    }

    public static Address getTorusAddress(Convex convex) {
        if (torusAddress != null) {
            return torusAddress;
        }
        try {
            torusAddress = (Address)convex.resolve("torus.exchange").get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return torusAddress;
    }

    public static TokenInfo get(Convex convex, ACell tokenID) {
        TokenInfo tokenInfo = new TokenInfo(tokenID);
        if (tokenID == null) {
            return tokenInfo;
        }
        try {
            Result r = convex.querySync("(" + String.valueOf(TokenInfo.getFungibleAddress(convex)) + "/decimals " + String.valueOf(tokenID) + ")");
            if (r.isError()) {
                System.err.println("Dubious Token: " + r.toString());
                return null;
            }
            CVMLong decimals = RT.ensureLong((ACell)r.getValue());
            if (decimals == null) {
                return null;
            }
            tokenInfo.decimals = Utils.checkedInt((long)decimals.longValue());
            return tokenInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TokenInfo getFungible(Convex convex, String cnsName) {
        try {
            ACell tokenID = (ACell)convex.resolve(cnsName).get();
            TokenInfo tokenInfo = new TokenInfo(tokenID);
            tokenInfo.symbol = cnsName.substring(cnsName.lastIndexOf(".") + 1);
            Result r = convex.querySync("(" + String.valueOf(TokenInfo.getFungibleAddress(convex)) + "/decimals " + String.valueOf(tokenID) + ")");
            if (r.isError()) {
                System.err.println("Dubious Token: " + r.toString());
                return null;
            }
            CVMLong decimals = RT.ensureLong((ACell)r.getValue());
            if (decimals == null) {
                return null;
            }
            tokenInfo.decimals = Utils.checkedInt((long)decimals.longValue());
            return tokenInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TokenInfo getMulti(Convex convex, String key) {
        try {
            AVector tokenID = Vectors.of((Object[])new Object[]{TokenInfo.getMultiAddress(convex), Keyword.create((String)key)});
            TokenInfo tokenInfo = new TokenInfo((ACell)tokenID);
            tokenInfo.symbol = key;
            Result r = convex.querySync("(" + String.valueOf(TokenInfo.getFungibleAddress(convex)) + "/decimals " + String.valueOf(tokenID) + ")");
            if (r.isError()) {
                System.err.println("Dubious Token: " + r.toString());
                return null;
            }
            CVMLong decimals = RT.ensureLong((ACell)r.getValue());
            if (decimals == null) {
                return null;
            }
            tokenInfo.decimals = Utils.checkedInt((long)decimals.longValue());
            return tokenInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isConvex() {
        return this.id == null;
    }

    public BigDecimal decimalAmount(AInteger val) {
        BigDecimal d = new BigDecimal(val.big()).divide(BigDecimal.TEN.pow(this.decimals));
        return d;
    }
}

