/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.data.prim.AInteger;
import convex.core.lang.Reader;
import convex.gui.components.ActionButton;
import convex.gui.components.BalanceLabel;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.SwapPanel;
import convex.gui.wallet.TokenButton;
import convex.gui.wallet.TokenInfo;
import convex.gui.wallet.TokenInfoPanel;
import convex.gui.wallet.TokenListPanel;
import convex.gui.wallet.TransferPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TokenComponent
extends JPanel {
    protected Convex convex;
    protected BalanceLabel balanceLabel;
    private TokenInfo token;
    static final Font BALANCE_FONT = Toolkit.BIG_FONT;
    TokenButton tokenButton;

    public TokenComponent(Convex convex, TokenInfo token) {
        this.convex = convex;
        this.token = token;
        this.setLayout((LayoutManager)new MigLayout("", "[" + (Toolkit.ICON_SIZE + 100) + "][400]"));
        this.setBorder(Toolkit.createEmptyBorder(20));
        this.tokenButton = new TokenButton(token);
        this.add(this.tokenButton);
        this.balanceLabel = new BalanceLabel();
        this.balanceLabel.setDecimals(token.getDecimals());
        this.balanceLabel.setFont(BALANCE_FONT);
        this.balanceLabel.setToolTipText("Account balance for " + token.getSymbol());
        this.add((Component)this.balanceLabel, "align right");
        JPanel actions = new JPanel();
        actions.add(ActionButton.build(59534, e -> JOptionPane.showMessageDialog(this, new TokenInfoPanel(convex, token), "Token Info", 1), "Show token information"));
        actions.add(ActionButton.build(57699, e -> new TransferPanel(convex, token).runNonModal(this), "Send this token to another account"));
        actions.add(ActionButton.build(59699, e -> {
            TokenInfo with = TokenListPanel.getOtherToken(token);
            if (with == null) {
                String tok = JOptionPane.showInputDialog(this, (Object)"Specify a token to swap with");
                if (tok == null) {
                    return;
                }
                try {
                    with = TokenInfo.get(convex, Reader.read((String)tok));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (with == null) {
                JOptionPane.showInputDialog(this, (Object)"Can't find token");
                return;
            }
            new SwapPanel(convex, token, with).runNonModal(this);
        }, "Open token swap window for this token"));
        actions.add(ActionButton.build(58837, e -> this.refresh(convex), "Refresh token info"));
        actions.add(ActionButton.build(59506, e -> TokenListPanel.model.removeElement(token), "Remove token from tracked list"));
        this.add((Component)actions, "dock east");
        this.refresh(convex);
    }

    public void refresh(Convex convex) {
        try {
            ((CompletableFuture)this.token.getBalance(convex).thenAccept(bal -> {
                if (bal != null) {
                    this.balanceLabel.setBalance((AInteger)bal);
                } else {
                    this.balanceLabel.setBalance(null);
                }
            })).exceptionally(e -> {
                e.printStackTrace();
                this.balanceLabel.setBalance(null);
                return null;
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

