/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.cvm.Address;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.util.ThreadUtils;
import convex.core.util.Utils;
import convex.gui.components.BalanceLabel;
import convex.gui.components.Identicon;
import convex.gui.utils.SymbolIcon;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AccountOverview
extends JPanel {
    final BalanceLabel balance = new BalanceLabel();
    final JLabel nameLabel = new JLabel("anonymous");
    final JLabel addressLabel = new JLabel();
    Identicon identicon = new Identicon(null, Toolkit.IDENTICON_SIZE * 2);
    private Convex convex;

    public AccountOverview(Convex convex) {
        this.convex = convex;
        this.setLayout((LayoutManager)new MigLayout("fill", "", "push[][]"));
        Font font = this.getFont();
        JLabel accountLabel = new JLabel(SymbolIcon.get(59389, 200.0));
        accountLabel.setHorizontalAlignment(0);
        accountLabel.setHorizontalTextPosition(0);
        accountLabel.setVerticalTextPosition(3);
        accountLabel.setIconTextGap(0);
        accountLabel.setFont(font.deriveFont(40.0f));
        this.add((Component)accountLabel, "dock west");
        this.add(new JLabel("Name"));
        this.add(new JLabel("Address"));
        this.add(new JLabel("Identicon"));
        this.add((Component)new JLabel("Convex Coin Balance"), "wrap");
        Font bigfont = font.deriveFont(40.0f);
        this.nameLabel.setFont(bigfont);
        this.nameLabel.setToolTipText("Convex user ID associated with this account (can be anonymous)");
        this.add(this.nameLabel);
        this.addressLabel.setToolTipText("Address of this account in the global state");
        this.addressLabel.setFont(bigfont);
        this.add(this.addressLabel);
        this.add(this.identicon);
        this.balance.setFont(bigfont);
        this.add(this.balance);
        this.update();
        ThreadUtils.runVirtual(this::updateLoop);
    }

    private void updateLoop() {
        while (!Thread.currentThread().isInterrupted() && this.convex.isConnected()) {
            try {
                Thread.sleep(1000L);
                if (!this.isShowing()) continue;
                this.update();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void update() {
        block6: {
            try {
                Address a = this.convex.getAddress();
                String addrString = RT.toString((ACell)a);
                if (this.addressLabel.getText() != addrString) {
                    this.addressLabel.setText(addrString);
                }
                AccountKey key = this.convex.getAccountKey(a);
                this.identicon.setKey((AArrayBlob)key);
                try {
                    CVMLong bal = CVMLong.create((Long)this.convex.getBalance());
                    if (Utils.equals((ACell)bal, (ACell)this.balance.getBalance())) break block6;
                    this.balance.setBalance((AInteger)bal);
                    if (bal != null) {
                        this.balance.setToolTipText("Convex coin balance (" + String.valueOf(bal) + " coppers)");
                        break block6;
                    }
                    this.balance.setToolTipText("Convex coin balance not available");
                }
                catch (ResultException e) {
                    this.balance.setBalance(null);
                    this.balance.setToolTipText("Convex coin balance not available: " + e.getMessage());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

