/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.tools;

import convex.dlfs.DLFS;
import convex.gui.components.AbstractGUI;
import convex.gui.dlfs.DLFSPanel;
import convex.gui.keys.KeyGenPanel;
import convex.gui.keys.KeyRingPanel;
import convex.gui.tools.MessageFormatPanel;
import convex.gui.tools.SystemInfoPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackerTools
extends AbstractGUI {
    private static final Logger log = LoggerFactory.getLogger((String)HackerTools.class.getName());
    static boolean clientMode = false;
    public JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();
    private KeyGenPanel keyGenPanel;
    private MessageFormatPanel messagePanel;
    private DLFSPanel dataPanel = new DLFSPanel(DLFS.createLocal());

    public static void main(String[] args) throws TimeoutException {
        log.info("Running Convex HackerTools");
        Toolkit.init();
        HackerTools gui = new HackerTools();
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }

    public HackerTools() {
        super("Hacker Tools");
        this.setLayout(new BorderLayout());
        this.keyGenPanel = new KeyGenPanel(null);
        this.messagePanel = new MessageFormatPanel();
        this.add((Component)this.tabs, "Center");
        this.tabs.add("KeyGen", this.keyGenPanel);
        this.tabs.add("KeyRing", new KeyRingPanel());
        this.tabs.add("Encoding", this.messagePanel);
        this.tabs.add("Data Lattice", this.dataPanel);
        this.tabs.add("System Info", new SystemInfoPanel());
        this.setPreferredSize(new Dimension(1024, 768));
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
        frame.setBounds(200, 200, 1024, 768);
    }
}

