/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.server;

import convex.api.Convex;
import convex.core.text.Text;
import convex.gui.components.ActionPanel;
import convex.gui.components.CodeLabel;
import convex.gui.components.NonUpdatingCaret;
import convex.gui.utils.Toolkit;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class PeerInfoPanel
extends JPanel {
    private final CodeLabel textArea;

    public PeerInfoPanel(final Convex p) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel panel = new ActionPanel();
        this.add((Component)panel, "South");
        JButton refreshButton = new JButton("Refresh");
        panel.add(refreshButton);
        this.textArea = new CodeLabel();
        this.textArea.setFont(Toolkit.MONO_FONT);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBackground(null);
        this.textArea.setCaret(new NonUpdatingCaret());
        this.textArea.setColumns(100);
        this.textArea.setRows(40);
        this.textArea.setMaxColumns(100);
        JScrollPane jsp1 = new JScrollPane(this.textArea);
        this.add((Component)jsp1, "Center");
        int INTERVAL = 500;
        final Timer timer = new Timer(INTERVAL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeerInfoPanel.this.updateState(p);
            }
        });
        timer.start();
        this.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentHidden(ComponentEvent ce) {
                timer.stop();
            }

            @Override
            public void componentShown(ComponentEvent ce) {
                timer.start();
            }
        });
        refreshButton.addActionListener(e -> this.updateState(p));
        this.updateState(p);
    }

    protected String lpad(Object s) {
        return Text.leftPad((String)s.toString(), (int)30);
    }

    private void updateState(Convex p) {
        StringBuilder sb = new StringBuilder();
        Server s = p.getLocalServer();
        if (s == null) {
            sb.append("Not a local Peer");
        } else {
            sb.append("Running:              " + s.isLive() + "\n");
            sb.append("Key:                  " + String.valueOf(s.getPeerKey()) + "\n");
            sb.append("Address:              " + String.valueOf(s.getHostAddress()) + "\n");
            sb.append("Store:                " + String.valueOf(s.getStore()) + "\n");
            sb.append("\n");
            sb.append(String.valueOf(s.getStatusData()) + "\n");
            sb.append("\n");
            sb.append("Transactions:\n");
            sb.append("- Received:           " + s.getTransactionHandler().receivedTransactionCount + "\n");
            sb.append("- Queued (valid):     " + s.getTransactionHandler().clientTransactionCount + "\n");
            sb.append("- Pending:            " + s.getTransactionHandler().countInterests() + "\n");
            sb.append("\n");
            sb.append("Beliefs Sent:         " + s.getBeliefPropagator().getBeliefBroadcastCount() + "\n");
            sb.append("Beliefs Received:     " + s.getBeliefReceivedCount() + "\n");
            sb.append("\n");
            sb.append("Load averages:\n");
            sb.append("- Transaction handler:  " + this.load((AThreadedComponent)s.getTransactionHandler()) + "\n");
            sb.append("- Query handler:        " + this.load((AThreadedComponent)s.getQueryProcessor()) + "\n");
            sb.append("- Belief Propagator:    " + this.load((AThreadedComponent)s.getBeliefPropagator()) + "\n");
            sb.append("- CVM Executor:         " + this.load((AThreadedComponent)s.getCVMExecutor()) + "\n");
            sb.append("- Connection Manager:   " + this.load((AThreadedComponent)s.getConnectionManager()) + "\n");
        }
        this.textArea.setText(sb.toString());
    }

    private String load(AThreadedComponent comp) {
        double ld = comp.getLoad();
        return Text.leftPad((String)((long)(ld * 100.0) + "%"), (int)6);
    }
}

