/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.models;

import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.MapEntry;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMDouble;
import convex.core.lang.Reader;
import convex.gui.models.BaseTableModel;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TorusTableModel
extends BaseTableModel {
    protected State state;
    protected Address torus;
    protected Address asset;
    private static final String[] FIXED_COLS = new String[]{"Token", "Market", "Pool AMT", "Pool CVX", "Price"};
    private static final Symbol SYM_MARKETS = Symbol.create((String)"markets");
    NumberFormat formatter = new DecimalFormat("#0.000000");

    public TorusTableModel(State state) {
        this.state = state;
        this.torus = (Address)this.eval("(import torus.exchange)");
        this.asset = (Address)this.eval("(import convex.asset)");
    }

    @Override
    public String getColumnName(int col) {
        if (col < FIXED_COLS.length) {
            return FIXED_COLS[col];
        }
        return "FOO";
    }

    @Override
    public int getRowCount() {
        AMap<ACell, ACell> markets = this.getMarkets();
        return (int)markets.count();
    }

    public AMap<ACell, ACell> getMarkets() {
        AccountStatus as = this.state.getAccount(this.torus);
        AMap markets = (AMap)as.getEnvironment().get((ACell)SYM_MARKETS);
        return markets;
    }

    @Override
    public int getColumnCount() {
        return FIXED_COLS.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AMap<ACell, ACell> markets = this.getMarkets();
        MapEntry me = markets.entryAt((long)rowIndex);
        ACell token = me.getKey();
        Address marketAddr = (Address)me.getValue();
        switch (columnIndex) {
            case 0: {
                return me.getKey();
            }
            case 1: {
                return marketAddr;
            }
            case 2: {
                return this.eval("(" + String.valueOf(this.asset) + "/balance " + String.valueOf(token) + " " + String.valueOf(marketAddr) + ")");
            }
            case 3: {
                return this.eval("(balance " + String.valueOf(marketAddr) + ")");
            }
            case 4: {
                CVMDouble d = (CVMDouble)this.eval("(" + String.valueOf(this.torus) + "/price " + String.valueOf(token) + ")");
                if (d == null) {
                    return "No price";
                }
                double p = d.doubleValue();
                return this.formatter.format(p);
            }
        }
        return "";
    }

    private <T extends ACell> T eval(String code) {
        Context ctx = Context.create((State)this.state);
        ACell result = (ACell)ctx.eval(Reader.read((String)code)).getValue();
        return (T)result;
    }

    public void setState(State newState) {
        if (this.state != newState) {
            this.state = newState;
            this.fireTableDataChanged();
        }
    }

    public AccountStatus getEntry(long ix) {
        return (AccountStatus)this.state.getAccounts().get(ix);
    }
}

