/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.core.data.ABlob;
import convex.core.data.AVector;
import convex.core.util.Utils;
import convex.dlfs.DLFSNode;
import convex.dlfs.DLPath;
import convex.gui.components.CodePane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PreviewPanel
extends JPanel {
    protected Path path;
    private CodePane information;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm z").withZone(ZoneId.systemDefault());

    public PreviewPanel() {
        this.setLayout((LayoutManager)new MigLayout("wrap 1"));
        this.information = new CodePane();
        this.information.setBackground(null);
        this.information.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.information, "span");
        this.setPath(null);
    }

    public void setPath(Path path) {
        StringBuilder sb;
        block13: {
            this.path = path;
            sb = new StringBuilder();
            try {
                if (path != null && Files.exists(path, new LinkOption[0])) {
                    boolean isDir = Files.isDirectory(path, new LinkOption[0]);
                    Path fname = path.getFileName();
                    sb.append("Name:        " + (fname == null ? "<root>" : fname.toString()) + "\n");
                    sb.append("Path:        " + path.toString() + "\n");
                    sb.append("Type:        " + (isDir ? "Directory" : "File") + "\n");
                    sb.append("\n");
                    Instant utime = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                    sb.append("Modified:    " + this.formatter.format(utime) + "\n");
                    sb.append("\n");
                    sb.append("             " + String.valueOf(utime) + "\n");
                    sb.append("\n");
                    if (path instanceof DLPath) {
                        DLPath dp = (DLPath)path;
                        AVector node = dp.getFileSystem().getNode(dp);
                        if (isDir) {
                            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                                sb.append("DLFS Directory accessible\n");
                            }
                            sb.append("Entries:     " + DLFSNode.getDirectoryEntries((AVector)node).count() + "\n");
                        } else {
                            ABlob data = DLFSNode.getData((AVector)node);
                            sb.append("File Size:   " + data.count() + "\n");
                            sb.append("Data Hash:   " + String.valueOf(data.getHash()) + "\n");
                        }
                        sb.append("Node Hash:   " + String.valueOf(node.getHash()) + "\n");
                        break block13;
                    }
                    sb.append("Not a DLFS file: " + Utils.getClassName((Object)path));
                    break block13;
                }
                sb.append("No file selected");
            }
            catch (Exception e) {
                e.printStackTrace();
                sb.append("\n\nERROR: " + e.getMessage());
            }
        }
        this.information.setText(sb.toString());
    }
}

