/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class BrowserUtils {
    protected static boolean copyFiles(JComponent parent, List<File> files, Path targetDir) throws IOException {
        boolean copied = false;
        block0: for (File f : files) {
            String fname = f.getName();
            Path targetPath = targetDir.resolve(fname);
            while (Files.exists(targetPath, new LinkOption[0])) {
                if ((fname = JOptionPane.showInputDialog(parent, "File name already exists, enter a new name:", fname)) == null) continue block0;
                targetPath = targetDir.resolve(fname);
            }
            Path p = Files.copy(f.toPath(), targetPath, new CopyOption[0]);
            System.out.println("Copied " + Files.size(p) + " bytes to: " + p.toString());
            copied = true;
        }
        return copied;
    }

    protected static Icon getFileIcon(Path path) {
        String iconName = null;
        Icon icon = null;
        iconName = Files.isDirectory(path, new LinkOption[0]) ? "FileView.directoryIcon" : (Files.isRegularFile(path, new LinkOption[0]) ? "FileView.fileIcon" : "FileView.hardDriveIcon");
        if (iconName != null) {
            if (path.getNameCount() == 0) {
                icon = UIManager.getIcon("FileView.hardDriveIcon");
            } else {
                try {
                    icon = FileSystemView.getFileSystemView().getSystemIcon(path.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (icon == null) {
            icon = UIManager.getIcon(iconName);
        }
        return icon;
    }
}

