/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.account;

import convex.core.cvm.Address;
import convex.core.text.Text;
import convex.gui.utils.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AddressField
extends JTextField {
    public AddressField() {
        this.setFont(Toolkit.MONO_FONT);
        this.setBorder(null);
    }

    @Override
    protected Document createDefaultModel() {
        return new AddressDocument();
    }

    public Address getAddress() {
        return Address.parse((String)this.getText());
    }

    public class AddressDocument
    extends PlainDocument {
        @Override
        public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
            if (s == null) {
                return;
            }
            char[] cs = s.toCharArray();
            int n = cs.length;
            if (n == 0) {
                return;
            }
            if (offset > 0 && cs[0] == '#') {
                super.remove(0, offset);
                offset = 0;
            }
            for (int i = 0; i < n; ++i) {
                char c = cs[i];
                if (Text.isASCIIDigit((char)c) || offset == 0 && i == 0 && c == '#') continue;
                return;
            }
            super.insertString(offset, s, a);
        }
    }
}

