/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.account;

import convex.core.cvm.Address;
import convex.core.data.Vectors;
import convex.core.text.AddressFormat;
import convex.core.util.Utils;
import convex.gui.components.account.AddressField;
import convex.gui.utils.Toolkit;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import net.miginfocom.swing.MigLayout;

public class AddressCombo
extends JComboBox<Address> {
    private static Address PROTOTYPE = Address.create((long)100000L);
    private static TreeSet<Address> usedAddresses = new TreeSet();

    public AddressCombo(DefaultComboBoxModel<Address> model) {
        super(model);
        this.setEditor(new AddressEditor(this));
        this.setEditable(true);
        this.addItemListener(e -> {
            Address address = (Address)this.getSelectedItem();
            if (address != null && model.getIndexOf(address) < 0) {
                model.addElement(address);
                usedAddresses.add(address);
            }
            Toolkit.relinquishFocus(this);
        });
    }

    public AddressCombo() {
        this(usedAddresses);
    }

    public AddressCombo(Address ... addresses) {
        this(new DefaultComboBoxModel<Address>(addresses));
    }

    public AddressCombo(Collection<Address> addresses) {
        this(new DefaultComboBoxModel<Address>(addresses.toArray(new Address[0])));
    }

    @Override
    public Address getPrototypeDisplayValue() {
        return PROTOTYPE;
    }

    public static void main(String ... args) {
        Toolkit.init();
        JPanel p = new JPanel();
        p.setLayout((LayoutManager)new MigLayout("insets 20 20 20 20, wrap 1"));
        AddressCombo ac = new AddressCombo((Collection<Address>)Vectors.of((Object[])new Object[]{Address.ZERO, Address.create((long)12L), Address.MAX_VALUE}));
        p.add(ac);
        JLabel sel = new JLabel("Nothing selected");
        p.add(sel);
        ac.addItemListener(e -> {
            Object o = ac.getSelectedItem();
            sel.setText(String.valueOf(o) + " : " + Utils.getClassName((Object)o));
        });
        Toolkit.showMainFrame(p);
    }

    public Address getAddress() {
        Object a = this.getSelectedItem();
        if (a instanceof Address) {
            return (Address)a;
        }
        return null;
    }

    private class AddressEditor
    extends BasicComboBoxEditor {
        private AddressEditor(AddressCombo addressCombo) {
        }

        public Address getItem() {
            try {
                return (Address)AddressFormat.INSTANCE.parseObject(this.editor.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        protected AddressField createEditorComponent() {
            final AddressField fld = new AddressField();
            fld.addFocusListener(new FocusAdapter(this){

                @Override
                public void focusGained(FocusEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            fld.select(1, fld.getText().length());
                        }
                    });
                }
            });
            return fld;
        }
    }
}

