/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.util.Utils;
import convex.gui.MainGUI;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGUI
extends JPanel
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractGUI.class.getName());
    protected JFrame frame;
    private String title;
    private CompletableFuture<String> finished = new CompletableFuture();

    public AbstractGUI(String title) {
        this.title = title;
    }

    @Override
    public final void run() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractGUI.this.showFrame();
                    EventQueue.invokeLater(AbstractGUI.this::afterRun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void runNonModal(JComponent parent) {
        this.showFrame();
        if (parent != null) {
            Rectangle b = parent.getBounds();
            this.frame.setLocation(b.x + 100, b.y + 100);
        }
    }

    public void showFrame() {
        this.frame = new JFrame();
        this.frame.setTitle(this.title);
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(MainGUI.class.getResource("/images/Convex.png")));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractGUI.this.finished.completeAsync(() -> "Closed");
            }
        });
        this.setupFrame(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
        log.info("GUI displayed: " + Utils.getClassName((Object)this));
    }

    public void runUntilClosed() {
        this.run();
        this.waitForClose();
    }

    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }

    public void afterRun() {
    }

    public void waitForClose() {
        if (this.finished != null) {
            this.finished.join();
        }
        this.close();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void close() {
    }

    public void closeGUI() {
        this.close();
        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
    }

    static {
        Toolkit.init();
    }
}

