/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.actor;

import convex.api.ConvexLocal;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.MapEntry;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.Utils;
import convex.gui.actor.MarketsPanel;
import convex.gui.components.ActionPanel;
import convex.gui.components.CodeLabel;
import convex.gui.components.DefaultReceiveAction;
import convex.gui.components.Toast;
import convex.gui.models.OracleTableModel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePanel
extends JPanel {
    public static final Logger log = LoggerFactory.getLogger((String)OraclePanel.class.getName());
    ConvexLocal manager;
    JScrollPane scrollPane;
    long key = 1L;
    private final Consumer<Result> createMarketAction = new Consumer<Result>(){

        protected void handleResult(Object m) {
            if (m instanceof Address) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Address addr = (Address)m;
                MarketsPanel.marketList.addElement(addr);
                OraclePanel.this.showResult("Prediction market deployed: " + String.valueOf(addr));
            } else {
                String resultString = "Expected Address but got: " + String.valueOf(m);
                log.warn(resultString);
                Toast.display((JComponent)OraclePanel.this.scrollPane, resultString, Toast.FAIL);
            }
        }

        protected void handleError(long id, Object code, Object msg) {
            OraclePanel.this.showError(code, msg);
        }

        @Override
        public void accept(Result t) {
            if (t.isError()) {
                this.handleError((Long)RT.jvm((ACell)t.getID()), t.getErrorCode(), t.getValue());
            } else {
                this.handleResult(t.getValue());
            }
        }
    };
    private final DefaultReceiveAction receiveAction = new DefaultReceiveAction(this.scrollPane);

    public OraclePanel(ConvexLocal manager) {
        this.manager = manager;
        this.setLayout(new BorderLayout());
        Address oracleAddress = manager.getState().lookupCNS("convex.trusted-oracle");
        Address oracleActorAddress = manager.getState().lookupCNS("convex.trusted-oracle.actor");
        OracleTableModel tableModel = new OracleTableModel(manager.getState(), oracleActorAddress);
        JTable table = new JTable(tableModel);
        this.scrollPane = new JScrollPane(table);
        this.add((Component)new CodeLabel("Oracle at address: " + String.valueOf(oracleAddress)), "North");
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        table.getColumnModel().getColumn(0).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(0).setPreferredWidth(80);
        table.getColumnModel().getColumn(1).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(1).setPreferredWidth(300);
        table.getColumnModel().getColumn(2).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(2).setPreferredWidth(80);
        table.getColumnModel().getColumn(3).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(3).setPreferredWidth(300);
        table.setFont(Toolkit.MONO_FONT);
        table.getTableHeader().setFont(Toolkit.MONO_FONT.deriveFont(1));
        table.setAutoResizeMode(0);
        this.scrollPane.getViewport().setBackground(null);
        this.add((Component)this.scrollPane, "Center");
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        JButton createButton = new JButton("Create...");
        actionPanel.add(createButton);
        createButton.addActionListener(e -> {
            String desc = JOptionPane.showInputDialog(this, (Object)"Enter Oracle description as plain text:");
            if (desc == null || desc.isBlank()) {
                return;
            }
            ACell code = Reader.read((String)("(call " + String.valueOf(oracleAddress) + " (register " + this.key++ + "  {:desc \"" + desc + "\" :trust #{*address*}}))"));
            this.execute(code);
        });
        JButton finaliseButton = new JButton("Finalise...");
        actionPanel.add(finaliseButton);
        finaliseButton.addActionListener(e -> {
            String value = JOptionPane.showInputDialog(this, (Object)"Enter final value:");
            if (value == null || value.isBlank()) {
                return;
            }
            int ix = table.getSelectedRow();
            if (ix < 0) {
                return;
            }
            MapEntry me = tableModel.getList().entryAt((long)ix);
            ACell code = Reader.read((String)("(call " + String.valueOf(oracleAddress) + " (provide " + String.valueOf(me.getKey()) + " " + value + "))"));
            this.execute(code);
        });
        JButton makeMarketButton = new JButton("Make Market");
        actionPanel.add(makeMarketButton);
        makeMarketButton.addActionListener(e -> {
            int ix = table.getSelectedRow();
            if (ix < 0) {
                return;
            }
            MapEntry me = tableModel.getList().entryAt((long)ix);
            ACell key = me.getKey();
            log.info("Making market: " + String.valueOf(key));
            String opts = JOptionPane.showInputDialog("Enter a list of possible values (forms, may separate with commas)");
            if (opts == null || opts.isBlank()) {
                Toast.display((JComponent)this.scrollPane, "Prediction market making cancelled", Toast.INFO);
                return;
            }
            String outcomeString = "[" + opts + "]";
            try {
                String actorCode = Utils.readResourceAsString((String)"actors/prediction-market.con");
                String source = "(let [pmc " + actorCode + " ] (deploy (pmc  0x" + oracleAddress.toString() + " " + String.valueOf(key) + " " + outcomeString + ")))";
                ACell code = Reader.read((String)source);
                manager.transact(code).thenAcceptAsync(this.createMarketAction);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
    }

    private void execute(ACell code) {
        this.manager.transact(code).thenAcceptAsync((Consumer)this.receiveAction);
    }

    private void showError(Object code, Object msg) {
        String resultString = "Error executing transaction: " + String.valueOf(code) + " " + String.valueOf(msg);
        log.info(resultString);
        Toast.display((JComponent)this.scrollPane, resultString, Toast.FAIL);
    }

    private void showResult(Object v) {
        String resultString = "Transaction executed successfully\nResult: " + Utils.toString((Object)v);
        log.info(resultString);
        Toast.display((JComponent)this.scrollPane, resultString, Toast.SUCCESS);
    }
}

