/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.actor;

import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.lang.RT;
import convex.core.text.Text;
import convex.gui.models.StateModel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class AccountInfoPanel
extends JPanel {
    protected Address addr;
    protected JTextArea infoArea;

    public AccountInfoPanel(StateModel<State> manager, Address address) {
        this.addr = address;
        this.setLayout(new BorderLayout(0, 0));
        this.setPreferredSize(new Dimension(600, 400));
        this.infoArea = new JTextArea();
        this.add((Component)this.infoArea, "Center");
        this.infoArea.setBackground(null);
        this.infoArea.setFont(Toolkit.MONO_FONT);
        manager.addPropertyChangeListener(e -> this.updateInfo((State)e.getNewValue()));
        this.updateInfo(manager.getValue());
    }

    private void updateInfo(State latestState) {
        AccountStatus as = latestState.getAccount(this.addr);
        this.infoArea.setText(AccountInfoPanel.getInfoText(this.addr, as));
    }

    public static String getInfoText(Address actor, AccountStatus as) {
        if (as == null) {
            return "Account " + String.valueOf(actor) + " does not exist in current State\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Account:        " + actor.toString() + "\n");
        sb.append("\n");
        sb.append("Account Key:    " + String.valueOf(as.getAccountKey()) + "\n");
        sb.append("Sequence:       " + as.getSequence() + "\n");
        sb.append("Balance:        " + Text.toFriendlyBalance((long)as.getBalance()) + "\n");
        sb.append("Mem. Allowance: " + Text.toFriendlyNumber((long)as.getMemory()) + "\n");
        sb.append("Allowance:      " + as.getMemory() + "\n");
        sb.append("Controller:     " + String.valueOf(as.getController()) + "\n");
        sb.append("Parent:         " + String.valueOf(as.getParent()) + "\n");
        sb.append("Env Size:       " + RT.count((ACell)as.getEnvironment()) + "\n");
        sb.append("Holding Size:   " + RT.count((ACell)as.getHolding(actor)) + "\n");
        sb.append("\n");
        sb.append("Storage Size:   " + Cells.storageSize((ACell)as) + "\n");
        sb.append("\n");
        return sb.toString();
    }
}

