/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.client;

import convex.api.Convex;
import convex.core.State;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.gui.client.panels.HomePanel;
import convex.gui.components.models.StateModel;
import convex.gui.manager.mainpanels.AboutPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexClient
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)ConvexClient.class.getName());
    public static final AStore CLIENT_STORE = Stores.getGlobalStore();
    private static JFrame frame;
    private static StateModel<State> latestState;
    public static long maxBlock;
    protected Convex convex = null;
    JPanel panel = new JPanel();
    HomePanel homePanel = new HomePanel();
    AboutPanel aboutPanel = new AboutPanel();
    JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();

    public static void main(String[] args) {
        log.info("Running Convex Client");
        Toolkit.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    frame = new JFrame();
                    frame.setTitle("Convex Client");
                    frame.setIconImage(Toolkit.getImage(ConvexClient.class.getResource("/images/Convex.png")));
                    frame.setBounds(100, 100, 1024, 768);
                    frame.setDefaultCloseOperation(3);
                    ConvexClient window = new ConvexClient();
                    frame.getContentPane().add((Component)window, "Center");
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ConvexClient() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Home", this.homePanel);
        this.tabs.add("About", this.aboutPanel);
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    public static State getLatestState() {
        return latestState.getValue();
    }

    public static Component getFrame() {
        return frame;
    }

    public static StateModel<State> getStateModel() {
        return latestState;
    }

    static {
        latestState = StateModel.create(null);
        maxBlock = 0L;
    }
}

