/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.etch.panels;

import convex.gui.components.ActionPanel;
import convex.gui.etch.EtchExplorer;
import etch.EtchStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePanel
extends JPanel {
    public static final Logger log = LoggerFactory.getLogger((String)DatabasePanel.class.getName());

    public DatabasePanel(EtchExplorer explorer) {
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.add(panel);
        panel.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel filePanel = new JPanel();
        filePanel.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "File", 4, 2, null, new Color(0, 0, 0)));
        panel.add(filePanel);
        filePanel.setLayout(new BorderLayout(0, 0));
        JLabel lblSelectPrompt = new JLabel("Select an Etch Database to Explore");
        filePanel.add((Component)lblSelectPrompt, "North");
        JLabel lblDatabaseFile = new JLabel();
        filePanel.add(lblDatabaseFile);
        lblDatabaseFile.setText(explorer.getStore().getFileName());
        explorer.getEtchState().addPropertyChangeListener(pc -> lblDatabaseFile.setText(((EtchStore)pc.getNewValue()).getFileName()));
        ActionPanel actionPanel = new ActionPanel();
        filePanel.add((Component)actionPanel, "South");
        JButton btnOpen = new JButton("Open File...");
        actionPanel.add(btnOpen);
        JFileChooser fc = new JFileChooser();
        btnOpen.addActionListener(e -> {
            if (e.getSource() == btnOpen) {
                fc.setCurrentDirectory(explorer.getStore().getFile());
                int returnVal = fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    log.info("Opening Etch Database: {}", (Object)file.getName());
                    if (file.exists()) {
                        try {
                            EtchStore newEtch = EtchStore.create((File)file);
                            explorer.setStore(newEtch);
                        }
                        catch (IOException ex) {
                            log.error("Error opening Etch database: " + ex.getMessage());
                        }
                    }
                }
            }
        });
        JLabel lblWelome = new JLabel("Welcome to Convex");
        lblWelome.setFont(new Font("Monospaced", 0, 18));
        lblWelome.setHorizontalAlignment(0);
        panel.add(lblWelome);
    }
}

