/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels.actors;

import convex.core.State;
import convex.core.crypto.WalletEntry;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Lists;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.Symbols;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.DefaultReceiveAction;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.mainpanels.actors.MarketsPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarketComponent
extends BaseListComponent {
    private Address address;
    AVector<ACell> outcomes;
    HashMap<Object, JLabel> probLabels = new HashMap();
    HashMap<Object, JLabel> tsLabels = new HashMap();
    HashMap<Object, JLabel> osLabels = new HashMap();
    CodeLabel title;
    private int numOutcomes;
    private MarketsPanel marketsPanel;
    static DecimalFormat probFormatter = new DecimalFormat("0.0");

    public MarketComponent(MarketsPanel marketsPanel, Address addr) {
        this.marketsPanel = marketsPanel;
        this.address = addr;
        State state = PeerGUI.getLatestState();
        AMap pmEnv = state.getEnvironment(addr);
        this.outcomes = RT.keys((ACell)pmEnv.get((ACell)Symbol.create((String)"totals")));
        this.numOutcomes = this.outcomes.size();
        Address oracleAddress = (Address)pmEnv.get((ACell)Symbol.create((String)"oracle"));
        if (oracleAddress == null) {
            throw new Error("No oracle symbol in environment?");
        }
        ACell key = pmEnv.get((ACell)Symbol.create((String)"oracle-key"));
        AMap oracleEnv = state.getEnvironment(oracleAddress);
        AMap fullList = (AMap)oracleEnv.get((ACell)Symbol.create((String)"full-list"));
        AMap oracleData = (AMap)fullList.get((Object)key);
        if (oracleData == null) {
            throw new Error("No oracle data for key?");
        }
        this.setLayout(new BorderLayout());
        String oName = (String)RT.jvm((ACell)oracleData.get((ACell)Keyword.create((String)"desc")));
        if (oName == null) {
            oName = "Nameless Oracle";
        }
        this.title = new CodeLabel(oName);
        this.title.setFont(Toolkit.MONO_FONT);
        this.add((Component)this.title, "North");
        JPanel jp = new JPanel();
        this.add((Component)jp, "Center");
        jp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        jp.add(new JLabel("Outcome"));
        gbc.gridx = 1;
        jp.add(new JLabel("Probability"));
        gbc.gridx = 2;
        jp.add(new JLabel("Total Stake"));
        gbc.gridx = 3;
        jp.add(new JLabel("Owned Stake"));
        gbc.gridx = 4;
        jp.add(new JLabel("Actions"));
        for (int i = 0; i < this.numOutcomes; ++i) {
            ACell outcome = this.outcomes.get(i);
            gbc.gridy = 1 + i;
            gbc.gridx = 0;
            JLabel oLabel = new JLabel(outcome.toString() + "   ");
            oLabel.setHorizontalAlignment(2);
            jp.add((Component)oLabel, gbc);
            gbc.gridx = 1;
            JLabel pLabel = new JLabel("??");
            jp.add((Component)pLabel, gbc);
            this.probLabels.put(outcome, pLabel);
            gbc.gridx = 2;
            JLabel tsLabel = new JLabel("0");
            jp.add((Component)tsLabel, gbc);
            this.tsLabels.put(outcome, tsLabel);
            gbc.gridx = 3;
            JLabel osLabel = new JLabel("0");
            jp.add((Component)osLabel, gbc);
            this.osLabels.put(outcome, osLabel);
            gbc.gridx = 4;
            JPanel bp = new JPanel();
            bp.setLayout(new GridLayout(0, 2));
            JButton buyButton = new JButton("Buy");
            buyButton.addActionListener(e -> this.buy(outcome));
            bp.add(buyButton);
            JButton sellButton = new JButton("Sell");
            sellButton.addActionListener(e -> this.sell(outcome));
            bp.add(sellButton);
            jp.add((Component)bp, gbc);
        }
        this.add((Component)new CodeLabel("Market Address: " + this.address.toString()), "South");
        this.updateStatus(state);
        PeerGUI.getStateModel().addPropertyChangeListener(e -> {
            State s = (State)e.getNewValue();
            this.updateStatus(s);
        });
        marketsPanel.acctChooser.addressCombo.addActionListener(e -> {
            State s = PeerGUI.getLatestState();
            this.updateStatus(s);
        });
    }

    private void sell(Object outcome) {
        this.changeStake(outcome, -1000000L);
    }

    private void buy(Object outcome) {
        this.changeStake(outcome, 1000000L);
    }

    private void changeStake(Object outcome, long delta) {
        State state = PeerGUI.getLatestState();
        Long stk = this.getStake(state, outcome);
        if (stk == null) {
            stk = 0L;
        }
        long newStake = Math.max(0L, stk + delta);
        long offer = Math.max(0L, delta);
        WalletEntry we = this.marketsPanel.acctChooser.getWalletEntry();
        AList cc = Lists.of((Object[])new Object[]{Symbol.create((String)"stake"), outcome, newStake});
        List cmd = List.of((Object[])new Object[]{Symbols.CALL, this.address, offer, cc});
        PeerGUI.execute(we, (ACell)cmd).thenAcceptAsync((Consumer)new DefaultReceiveAction(this.marketsPanel));
    }

    private void updateStatus(State state) {
        try {
            Address caller = this.marketsPanel.acctChooser.getSelectedAddress();
            Context ctx = Context.createFake((State)state, (Address)caller);
            for (int i = 0; i < this.numOutcomes; ++i) {
                ACell outcome = this.outcomes.get(i);
                double p = (Double)RT.jvm((ACell)ctx.actorCall((ACell)this.address, 0L, "price", new ACell[]{outcome}).getResult());
                if (Double.isNaN(p)) {
                    p = 1.0 / (double)this.numOutcomes;
                }
                String prob = probFormatter.format(p * 100.0) + "%";
                this.probLabels.get(outcome).setText(prob);
                Long ts = (Long)RT.jvm((ACell)ctx.actorCall((ACell)this.address, 0L, "totals", new ACell[]{outcome}).getResult());
                String totalStake = ts.toString();
                this.tsLabels.get(outcome).setText(totalStake);
                AMap stks = (AMap)ctx.actorCall((ACell)this.address, 0L, "stakes", new ACell[]{outcome}).getResult();
                CVMLong stk = (CVMLong)stks.get((ACell)caller);
                String ownStake = stk == null ? "0" : stk.toString();
                this.osLabels.get(outcome).setText(ownStake);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Long getStake(State state, Object outcome) {
        Address caller = this.marketsPanel.acctChooser.getSelectedAddress();
        Context ctx = Context.createFake((State)state, (Address)caller);
        AMap stks = (AMap)ctx.actorCall((ACell)this.address, 0L, "stakes", new ACell[]{RT.cvm((Object)outcome)}).getResult();
        return ((CVMLong)stks.get((ACell)caller)).longValue();
    }
}

