/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.BIP39;
import convex.core.crypto.WalletEntry;
import convex.core.data.ABlob;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Hash;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.mainpanels.WalletPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class KeyGenPanel
extends JPanel {
    JTextArea mnemonicArea;
    JPasswordField passArea;
    JTextArea seedArea;
    JTextArea privateKeyArea;
    JTextArea publicKeyArea;
    JSpinner numSpinner;
    JButton addWalletButton = new JButton("Add to wallet");
    int FONT_SIZE = 16;
    Font HEX_FONT = new Font("Monospaced", 1, this.FONT_SIZE);

    protected String hexKeyFormat(String pk) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pk.length() / 32; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            for (int j = 0; j < 4; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                int ix = 8 * (j + i * 4);
                sb.append(pk.substring(ix, ix + 8));
            }
        }
        return sb.toString();
    }

    private void updateMnemonic() {
        this.generateSeed();
    }

    private void updatePass() {
        this.generateSeed();
    }

    private void generateSeed() {
        String s = this.mnemonicArea.getText();
        String p = new String(this.passArea.getPassword());
        try {
            List words = BIP39.getWords((String)s);
            Blob keyMat = BIP39.getSeed((List)words, (String)p);
            this.seedArea.setText(keyMat.toHexString());
            Hash seed = keyMat.getContentHash();
            String privateKeyString = seed.toHexString();
            this.privateKeyArea.setText(privateKeyString);
        }
        catch (Exception ex) {
            String pks = "<mnemonic not valid>";
            if (s.isBlank()) {
                pks = "<enter valid private key or mnemonic>";
            }
            this.privateKeyArea.setText(pks);
        }
        this.generatePublicKeys();
    }

    private void updateSeed() {
        try {
            this.mnemonicArea.setText("<can't recreate from BIP39 seed>");
            ABlob b = Blobs.parse((String)this.seedArea.getText());
            if (b == null || b.count() != 64L) {
                throw new IllegalArgumentException("Dummy");
            }
            this.privateKeyArea.setText(b.getContentHash().toHexString());
            this.generatePublicKeys();
        }
        catch (Exception ex) {
            this.privateKeyArea.setText("<invalid BIP39 seed>");
            this.publicKeyArea.setText("<invalid BIP39 seed>");
            return;
        }
    }

    private void updatePrivateKey() {
        try {
            this.mnemonicArea.setText("<can't recreate from private key>");
            this.seedArea.setText("<can't recreate from private key>");
            this.generatePublicKeys();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return;
        }
    }

    private void generatePublicKeys() {
        String s = this.privateKeyArea.getText();
        try {
            Blob b = Blob.fromHex((String)Utils.stripWhiteSpace((String)s));
            AKeyPair kp = AKeyPair.create((byte[])b.getBytes());
            this.publicKeyArea.setText("0x" + kp.getAccountKey().toChecksumHex());
            this.addWalletButton.setEnabled(true);
        }
        catch (Exception ex) {
            this.publicKeyArea.setText("<enter valid private key>");
            this.addWalletButton.setEnabled(false);
            return;
        }
    }

    public KeyGenPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        JButton btnRecreate = new JButton("Generate");
        actionPanel.add(btnRecreate);
        btnRecreate.addActionListener(e -> {
            Integer wc = (Integer)this.numSpinner.getValue();
            this.mnemonicArea.setText(BIP39.createSecureRandom((int)wc));
            this.updateMnemonic();
        });
        this.numSpinner = new JSpinner();
        this.numSpinner.setModel(new SpinnerNumberModel(12, 1, 30, 1));
        actionPanel.add(this.numSpinner);
        JButton btnNewButton = new JButton("Export...");
        actionPanel.add(btnNewButton);
        JButton btnNormalise = new JButton("Normalise Mnemonic");
        actionPanel.add(btnNormalise);
        btnNormalise.addActionListener(e -> {
            String s = this.mnemonicArea.getText();
            this.mnemonicArea.setText(BIP39.normalise((String)s));
            this.updateMnemonic();
        });
        actionPanel.add(this.addWalletButton);
        this.addWalletButton.addActionListener(e -> {
            String pks = this.privateKeyArea.getText();
            pks = Utils.stripWhiteSpace((String)pks);
            WalletEntry we = WalletEntry.create(null, (AKeyPair)AKeyPair.create((byte[])Utils.hexToBytes((String)pks)));
            WalletPanel.addWalletEntry(we);
            manager.switchPanel("Wallet");
        });
        JPanel formPanel = new JPanel();
        formPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)formPanel, "North");
        GridBagLayout gbl_formPanel = new GridBagLayout();
        gbl_formPanel.columnWidths = new int[]{156, 347, 0};
        gbl_formPanel.rowHeights = new int[]{22, 0, 0, 0, 0};
        gbl_formPanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_formPanel.rowWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        formPanel.setLayout(gbl_formPanel);
        JLabel lblMnemonic = new JLabel("Mnenomic Phrase");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        formPanel.add((Component)lblMnemonic, gbc_lblNewLabel);
        this.mnemonicArea = new JTextArea();
        this.mnemonicArea.setWrapStyleWord(true);
        this.mnemonicArea.setLineWrap(true);
        this.mnemonicArea.setRows(2);
        GridBagConstraints gbc_mnemonicArea = new GridBagConstraints();
        gbc_mnemonicArea.fill = 2;
        gbc_mnemonicArea.insets = new Insets(0, 0, 5, 0);
        gbc_mnemonicArea.gridx = 1;
        gbc_mnemonicArea.gridy = 0;
        this.mnemonicArea.setColumns(32);
        this.mnemonicArea.setFont(this.HEX_FONT);
        formPanel.add((Component)this.mnemonicArea, gbc_mnemonicArea);
        this.mnemonicArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.mnemonicArea.isFocusOwner()) {
                return;
            }
            this.updateMnemonic();
        }));
        JLabel lblPass = new JLabel("Passphrase");
        gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 1;
        formPanel.add((Component)lblPass, gbc_lblNewLabel);
        this.passArea = new JPasswordField();
        gbc_mnemonicArea = new GridBagConstraints();
        gbc_mnemonicArea.fill = 2;
        gbc_mnemonicArea.insets = new Insets(0, 0, 5, 0);
        gbc_mnemonicArea.gridx = 1;
        gbc_mnemonicArea.gridy = 1;
        this.passArea.setColumns(32);
        this.passArea.setFont(this.HEX_FONT);
        formPanel.add((Component)this.passArea, gbc_mnemonicArea);
        this.passArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.passArea.isFocusOwner()) {
                return;
            }
            this.updatePass();
        }));
        JLabel lblBIPSeed = new JLabel("BIP39 Seed");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 2;
        formPanel.add((Component)lblBIPSeed, gbc);
        this.seedArea = new JTextArea();
        this.seedArea.setFont(this.HEX_FONT);
        this.seedArea.setColumns(64);
        this.seedArea.setLineWrap(true);
        this.seedArea.setWrapStyleWord(false);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = new Insets(0, 0, 5, 0);
        gbc2.fill = 2;
        gbc2.gridx = 1;
        gbc2.gridy = 2;
        formPanel.add((Component)this.seedArea, gbc2);
        this.seedArea.setText("(mnemonic not ready)");
        this.seedArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.seedArea.isFocusOwner()) {
                return;
            }
            this.updateSeed();
        }));
        JLabel lblPrivateKey = new JLabel("Private key Ed25519 seed");
        GridBagConstraints gbc_lblPrivateKey = new GridBagConstraints();
        gbc_lblPrivateKey.anchor = 17;
        gbc_lblPrivateKey.insets = new Insets(0, 0, 5, 5);
        gbc_lblPrivateKey.gridx = 0;
        gbc_lblPrivateKey.gridy = 3;
        formPanel.add((Component)lblPrivateKey, gbc_lblPrivateKey);
        this.privateKeyArea = new JTextArea();
        this.privateKeyArea.setFont(this.HEX_FONT);
        GridBagConstraints gbc_privateKeyArea = new GridBagConstraints();
        gbc_privateKeyArea.insets = new Insets(0, 0, 5, 0);
        gbc_privateKeyArea.fill = 2;
        gbc_privateKeyArea.gridx = 1;
        gbc_privateKeyArea.gridy = 3;
        formPanel.add((Component)this.privateKeyArea, gbc_privateKeyArea);
        this.privateKeyArea.setText("(mnemonic not ready)");
        this.privateKeyArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.privateKeyArea.isFocusOwner()) {
                return;
            }
            this.updatePrivateKey();
        }));
        JLabel lblPublicKey = new JLabel("Public Key");
        GridBagConstraints gbc_lblPublicKey = new GridBagConstraints();
        gbc_lblPublicKey.anchor = 17;
        gbc_lblPublicKey.insets = new Insets(0, 0, 5, 5);
        gbc_lblPublicKey.gridx = 0;
        gbc_lblPublicKey.gridy = 4;
        formPanel.add((Component)lblPublicKey, gbc_lblPublicKey);
        this.publicKeyArea = new JTextArea();
        this.publicKeyArea.setEditable(false);
        this.publicKeyArea.setRows(1);
        this.publicKeyArea.setText("(private key not ready)");
        this.publicKeyArea.setFont(this.HEX_FONT);
        GridBagConstraints gbc_publicKeyArea = new GridBagConstraints();
        gbc_publicKeyArea.insets = new Insets(0, 0, 5, 0);
        gbc_publicKeyArea.fill = 2;
        gbc_publicKeyArea.gridx = 1;
        gbc_publicKeyArea.gridy = 4;
        formPanel.add((Component)this.publicKeyArea, gbc_publicKeyArea);
    }
}

