/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.core.State;
import convex.core.crypto.bc.BCKeyPair;
import convex.core.crypto.bc.BCProvider;
import convex.core.data.prim.CVMLong;
import convex.core.util.Counters;
import convex.core.util.Text;
import convex.gui.components.ActionPanel;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class AboutPanel
extends JPanel {
    private final JTextArea textArea;

    public AboutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel panel = new ActionPanel();
        this.add((Component)panel, "South");
        JButton creditsButton = new JButton("Credits");
        panel.add(creditsButton);
        JPanel panel_1 = new JPanel();
        this.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(null);
        this.textArea.setFont(Toolkit.SMALL_MONO_FONT);
        PeerGUI.getStateModel().addPropertyChangeListener(e -> this.updateState((State)e.getNewValue()));
        panel_1.add(this.textArea);
        creditsButton.addActionListener(e -> JOptionPane.showMessageDialog(null, "Icons made by Freepik from www.flaticon.com\nRoyalty free map image by J. Bruce Jones", "Credits", -1));
        this.updateState(PeerGUI.getLatestState());
    }

    private String lpad(Object s) {
        return Text.leftPad((String)s.toString(), (int)30);
    }

    private void updateState(State s) {
        StringBuilder sb = new StringBuilder();
        CVMLong timestamp = s.getTimestamp();
        sb.append("Consensus state hash: " + s.getHash().toHexString() + "\n");
        sb.append("Timestamp:            " + Text.dateFormat((long)timestamp.longValue()) + "   (" + timestamp + ")\n");
        sb.append("\n");
        sb.append("Max Blocks:           " + this.lpad(PeerGUI.maxBlock) + "\n");
        sb.append("\n");
        sb.append("Account statistics\n");
        sb.append("  # Accounts:         " + this.lpad(s.getAccounts().count()) + "\n");
        sb.append("  # Peers:            " + this.lpad(s.getPeers().count()) + "\n");
        sb.append("\n");
        sb.append("Globals\n");
        sb.append("  fees:               " + this.lpad(Text.toFriendlyNumber((long)s.getGlobalFees().longValue())) + "\n");
        sb.append("  juice-price:        " + this.lpad(Text.toFriendlyNumber((long)s.getJuicePrice().longValue())) + "\n");
        sb.append("\n");
        sb.append("Total funds:          " + this.lpad(Text.toFriendlyNumber((long)s.computeTotalFunds())) + "\n");
        sb.append("Total stake:          " + this.lpad(Text.toFriendlyIntString((double)((Double)s.computeStakes().get(null)))) + "\n");
        sb.append("\n");
        sb.append("BC Signatures:        " + this.lpad(BCKeyPair.signatureCount + "\n"));
        sb.append("BC Verifications:     " + this.lpad(BCProvider.verificationCount + "\n"));
        sb.append("\n");
        sb.append(Counters.getStats());
        this.textArea.setText(sb.toString());
    }
}

