/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager;

import convex.api.Convex;
import convex.core.Order;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.WalletEntry;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.init.Init;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.gui.components.models.StateModel;
import convex.gui.manager.mainpanels.AboutPanel;
import convex.gui.manager.mainpanels.AccountsPanel;
import convex.gui.manager.mainpanels.ActorsPanel;
import convex.gui.manager.mainpanels.HomePanel;
import convex.gui.manager.mainpanels.KeyGenPanel;
import convex.gui.manager.mainpanels.MessageFormatPanel;
import convex.gui.manager.mainpanels.PeersListPanel;
import convex.gui.manager.mainpanels.TorusPanel;
import convex.gui.manager.mainpanels.WalletPanel;
import convex.gui.utils.Toolkit;
import convex.peer.Server;
import convex.restapi.RESTServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGUI
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)PeerGUI.class.getName());
    private static JFrame frame;
    public static List<AKeyPair> KEYPAIRS;
    private static final int NUM_PEERS = 3;
    public static List<AccountKey> PEERKEYS;
    public static State genesisState;
    private static StateModel<State> latestState;
    public static StateModel<Long> tickState;
    public static long maxBlock;
    JPanel panel = new JPanel();
    HomePanel homePanel = new HomePanel();
    PeersListPanel peerPanel;
    WalletPanel walletPanel = new WalletPanel();
    KeyGenPanel keyGenPanel = new KeyGenPanel(this);
    MessageFormatPanel messagePanel = new MessageFormatPanel(this);
    AboutPanel aboutPanel = new AboutPanel();
    JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();
    JPanel accountsPanel = new AccountsPanel(this);
    RESTServer restServer;
    private boolean updateRunning = true;
    private long cp = 0L;
    private Thread updateThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (PeerGUI.this.updateRunning) {
                try {
                    Thread.sleep(100L);
                    tickState.setValue(tickState.getValue() + 1L);
                    List<Convex> peerViews = PeerGUI.this.peerPanel.getPeerViews();
                    PeerGUI.this.peerPanel.repaint();
                    State latest = latestState.getValue();
                    for (Convex s : peerViews) {
                        Order order;
                        Peer p;
                        Server serv = s.getLocalServer();
                        if (serv == null || (p = serv.getPeer()) == null || (order = p.getPeerOrder()) == null) continue;
                        maxBlock = Math.max(maxBlock, order.getBlockCount());
                        long pcp = p.getFinalityPoint();
                        if (pcp <= PeerGUI.this.cp) continue;
                        PeerGUI.this.cp = pcp;
                        latest = p.getConsensusState();
                    }
                    latestState.setValue(latest);
                }
                catch (InterruptedException e) {
                    log.warn("Update thread interrupted abnormally: " + e.getMessage());
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            log.debug("GUI Peer Manager update thread ended");
        }
    }, "GUI Manager state update thread");
    public static DefaultListModel<Convex> peerList;
    private static HashMap<Server, StateModel<Peer>> models;

    public static void main(String[] args) {
        Toolkit.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    frame = new JFrame();
                    frame.setTitle("Convex Peer Manager");
                    frame.setIconImage(java.awt.Toolkit.getDefaultToolkit().getImage(PeerGUI.class.getResource("/images/Convex.png")));
                    frame.setBounds(100, 100, 1024, 768);
                    frame.setDefaultCloseOperation(3);
                    final PeerGUI window = new PeerGUI();
                    frame.getContentPane().add((Component)window, "Center");
                    frame.pack();
                    frame.setVisible(true);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent winEvt) {
                            window.peerPanel.closePeers();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public PeerGUI() {
        this.peerPanel = new PeersListPanel(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Home", this.homePanel);
        this.tabs.add("Peers", this.peerPanel);
        this.tabs.add("Wallet", this.getWalletPanel());
        this.tabs.add("Accounts", this.accountsPanel);
        this.tabs.add("KeyGen", this.keyGenPanel);
        this.tabs.add("Message", this.messagePanel);
        this.tabs.add("Actors", new ActorsPanel(this));
        this.tabs.add("Torus", new TorusPanel(this));
        this.tabs.add("About", this.aboutPanel);
        this.tabs.setSelectedComponent(this.peerPanel);
        EventQueue.invokeLater(() -> {
            this.peerPanel.launchAllPeers(this);
            Server first = peerList.firstElement().getLocalServer();
            try {
                this.restServer = RESTServer.create((Server)first);
                this.restServer.start();
            }
            catch (Exception t) {
                log.warn("Unable to start REST Server:", (Throwable)t);
            }
        });
        this.updateThread.start();
    }

    public void finalize() {
        this.updateRunning = false;
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    public WalletPanel getWalletPanel() {
        return this.walletPanel;
    }

    public static Convex makeConnection(Address address, AKeyPair kp) throws IOException, TimeoutException {
        InetSocketAddress host = PeerGUI.getDefaultConvex().getHostAddress();
        return Convex.connect((InetSocketAddress)host, (Address)address, (AKeyPair)kp);
    }

    public static CompletableFuture<Result> execute(WalletEntry we, ACell code) {
        Address address = we.getAddress();
        AccountStatus as = PeerGUI.getLatestState().getAccount(address);
        long sequence = as.getSequence() + 1L;
        Invoke trans = Invoke.create((Address)address, (long)sequence, (ACell)code);
        return PeerGUI.execute(we, (ATransaction)trans);
    }

    public static CompletableFuture<Result> execute(WalletEntry we, ATransaction trans) {
        try {
            AKeyPair kp = we.getKeyPair();
            Convex convex = PeerGUI.makeConnection(we.getAddress(), kp);
            CompletableFuture fr = convex.transact(trans);
            log.trace("Sent transaction: {}", (Object)trans);
            return fr;
        }
        catch (IOException | TimeoutException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    public static void execute(WalletEntry we, ATransaction trans, Consumer<Result> receiveAction) {
        PeerGUI.execute(we, trans).thenAcceptAsync((Consumer)receiveAction);
    }

    public static State getLatestState() {
        return latestState.getValue();
    }

    public static Component getFrame() {
        return frame;
    }

    public static StateModel<State> getStateModel() {
        return latestState;
    }

    public static Convex getDefaultConvex() {
        return PeersListPanel.getFirst();
    }

    public static Address getUserAddress(int i) {
        return Init.getGenesisPeerAddress((int)i);
    }

    public static AKeyPair getUserKeyPair(int i) {
        return KEYPAIRS.get(i);
    }

    public static Address getGenesisAddress() {
        return Init.getGenesisAddress();
    }

    public static Convex connectClient(Address address, AKeyPair keyPair) {
        try {
            return PeerGUI.makeConnection(address, keyPair);
        }
        catch (IOException | TimeoutException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    public static StateModel<Peer> getStateModel(Convex peer) {
        Server s = peer.getLocalServer();
        if (s != null) {
            StateModel<Peer> model = models.get(s);
            if (model != null) {
                return model;
            }
            StateModel<Peer> newModel = StateModel.create(s.getPeer());
            s.getCVMExecutor().setUpdateHook(p -> {
                AStore tempStore = Stores.current();
                try {
                    Stores.setCurrent((AStore)s.getStore());
                    newModel.setValue((Peer)p);
                }
                finally {
                    Stores.setCurrent((AStore)tempStore);
                }
            });
            models.put(s, newModel);
            return newModel;
        }
        return null;
    }

    public static Server getRandomServer() {
        Server result = null;
        int n = peerList.getSize();
        int found = 0;
        for (int i = 0; i < n; ++i) {
            Convex c = peerList.elementAt(i);
            Server s = c.getLocalServer();
            if (s == null) continue;
            ++found;
            if (!(Math.random() * (double)found <= 1.0)) continue;
            result = s;
        }
        return result;
    }

    public static Server getPrimaryServer() {
        int n = peerList.getSize();
        for (int i = 0; i < n; ++i) {
            Convex c = peerList.elementAt(i);
            Server s = c.getLocalServer();
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static void runWithLatestState(Consumer<State> f) {
        AStore tempStore = Stores.current();
        try {
            Server s = PeerGUI.getPrimaryServer();
            Stores.setCurrent((AStore)s.getStore());
            f.accept(s.getPeer().getConsensusState());
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    public static void runOnPrimaryServer(Consumer<Server> f) {
        Server s = PeerGUI.getPrimaryServer();
        PeerGUI.runOnServer(s, f);
    }

    public static void runOnServer(Server server, Consumer<Server> f) {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)server.getStore());
            f.accept(server);
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    static {
        KEYPAIRS = new ArrayList<AKeyPair>();
        for (int i = 0; i < 3; ++i) {
            KEYPAIRS.add(AKeyPair.generate());
        }
        PEERKEYS = KEYPAIRS.stream().map(kp -> kp.getAccountKey()).collect(Collectors.toList());
        genesisState = Init.createState(PEERKEYS);
        latestState = StateModel.create(genesisState);
        tickState = StateModel.create(0L);
        maxBlock = 0L;
        peerList = new DefaultListModel();
        models = new HashMap();
    }
}

