/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Peer;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.PeerStatus;
import convex.core.util.Text;
import convex.gui.client.ConvexClient;
import convex.gui.components.BaseListComponent;
import convex.gui.components.BlockViewComponent;
import convex.gui.components.DropdownMenu;
import convex.gui.components.models.StateModel;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.windows.etch.EtchWindow;
import convex.gui.manager.windows.peer.PeerWindow;
import convex.gui.manager.windows.state.StateWindow;
import convex.gui.utils.Toolkit;
import convex.peer.ConnectionManager;
import convex.peer.Server;
import etch.EtchStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class PeerComponent
extends BaseListComponent {
    public Convex convex;
    JTextArea description;
    private PeerGUI manager;

    public void launchPeerWindow(Convex peer) {
        try {
            PeerWindow pw = new PeerWindow(this.manager, peer);
            pw.launch();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void launchEtchWindow(Convex peer) {
        EtchWindow ew = new EtchWindow(this.manager, peer);
        ew.launch();
    }

    public void launchExploreWindow(Convex peer) {
        Server s = peer.getLocalServer();
        State p = s.getPeer().getConsensusState();
        StateWindow pw = new StateWindow(this.manager, (ACell)p);
        pw.launch();
    }

    public PeerComponent(PeerGUI manager, Convex value) {
        JMenuItem closeButton;
        this.manager = manager;
        this.convex = value;
        this.setLayout(new BorderLayout(0, 0));
        JButton button = new JButton("");
        button.setBorder(null);
        this.add((Component)button, "West");
        button.setIcon(Toolkit.CONVEX);
        button.addActionListener(e -> this.launchPeerWindow(this.convex));
        button.setToolTipText("Launch Peer management window");
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        this.description = new JTextArea(this.convex == null ? "No peer" : this.convex.toString());
        this.description.setFont(Toolkit.SMALL_MONO_FONT);
        this.description.setEditable(false);
        this.description.setBorder(null);
        this.description.setBackground(null);
        panel.add((Component)this.description, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        Server server = this.convex.getLocalServer();
        if (server != null) {
            closeButton = new JMenuItem("Shutdown Peer");
            closeButton.addActionListener(e -> {
                try {
                    server.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            popupMenu.add(closeButton);
            JMenuItem exploreButton = new JMenuItem("Explore state");
            exploreButton.addActionListener(e -> this.launchExploreWindow(this.convex));
            popupMenu.add(exploreButton);
            if (server.getStore() instanceof EtchStore) {
                JMenuItem storeButton = new JMenuItem("Explore Etch store");
                storeButton.addActionListener(e -> this.launchEtchWindow(this.convex));
                popupMenu.add(storeButton);
            }
            JMenuItem killConn = new JMenuItem("Kill Connections");
            killConn.addActionListener(e -> server.getConnectionManager().closeAllConnections());
            popupMenu.add(killConn);
        } else {
            closeButton = new JMenuItem("Close connection");
            closeButton.addActionListener(e -> this.convex.close());
            popupMenu.add(closeButton);
        }
        JMenuItem replButton = new JMenuItem("Launch REPL");
        replButton.addActionListener(e -> this.launchPeerWindow(this.convex));
        popupMenu.add(replButton);
        JMenuItem clientButton = new JMenuItem("Connect Client");
        clientButton.addActionListener(e -> this.launchClientWindow(this.convex));
        popupMenu.add(clientButton);
        BlockViewComponent blockView = new BlockViewComponent(this.convex);
        this.add((Component)blockView, "South");
        DropdownMenu dm = new DropdownMenu(popupMenu);
        this.add((Component)dm, "East");
        StateModel<Peer> model = PeerGUI.getStateModel(this.convex);
        if (model != null) {
            model.addPropertyChangeListener(e -> {
                blockView.repaint();
                this.description.setText(this.getPeerDescription());
            });
        }
        PeerGUI.tickState.addPropertyChangeListener(e -> this.description.setText(this.getPeerDescription()));
    }

    private void launchClientWindow(Convex peer) {
        try {
            ConvexRemote convex = ConvexRemote.connect((InetSocketAddress)peer.getHostAddress());
            Address addr = peer.getAddress();
            AKeyPair kp = peer.getKeyPair();
            convex.setAddress(addr, kp);
            ConvexClient.launch((Convex)convex);
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    public String getPeerDescription() {
        StringBuilder sb = new StringBuilder();
        Server server = this.convex.getLocalServer();
        if (server != null) {
            PeerGUI.runOnServer(server, s -> {
                State state = s.getPeer().getConsensusState();
                AccountKey paddr = server.getPeerKey();
                sb.append("0x" + paddr.toChecksumHex() + "\n");
                sb.append("Local peer on: " + s.getHostAddress() + " with store " + s.getStore() + "\n");
                PeerStatus ps = state.getPeer(paddr);
                if (ps != null) {
                    sb.append("Peer Stake:  " + Text.toFriendlyNumber((long)ps.getPeerStake()));
                    sb.append("    ");
                    sb.append("Delegated Stake:  " + Text.toFriendlyNumber((long)ps.getDelegatedStake()));
                }
                ConnectionManager cm = server.getConnectionManager();
                sb.append("\n");
                sb.append("Connections: " + cm.getConnectionCount());
            });
        } else if (this.convex != null) {
            sb.append(this.convex.toString());
        } else {
            sb.append("Unknown");
        }
        return sb.toString();
    }
}

