/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.crypto.AKeyPair;
import convex.core.data.Address;
import convex.gui.components.PeerComponent;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.windows.BaseWindow;
import convex.gui.manager.windows.peer.PeerInfoPanel;
import convex.gui.manager.windows.peer.REPLPanel;
import convex.gui.manager.windows.peer.StressPanel;
import convex.peer.Server;
import java.awt.Component;
import java.net.InetSocketAddress;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerWindow
extends BaseWindow {
    Convex peer;
    private static final Logger log = LoggerFactory.getLogger((String)PeerWindow.class.getName());
    JTabbedPane tabbedPane = new JTabbedPane(1);

    public Convex getPeerView() {
        return this.peer;
    }

    public PeerWindow(PeerGUI manager, Convex peer) {
        super(manager);
        this.peer = peer;
        this.add((Component)this.tabbedPane, "Center");
        Server server = peer.getLocalServer();
        if (server != null) {
            try {
                ConvexRemote convex = Convex.connect((InetSocketAddress)server.getHostAddress(), (Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
                this.tabbedPane.addTab("REPL", null, new REPLPanel((Convex)convex), null);
            }
            catch (Throwable t) {
                log.warn("Unable to create Peer Controller Window");
            }
        }
        this.tabbedPane.addTab("Stress", null, new StressPanel(peer), null);
        this.tabbedPane.addTab("Info", null, new PeerInfoPanel(peer), null);
        PeerComponent pcom = new PeerComponent(manager, peer);
        this.add((Component)pcom, "North");
    }

    @Override
    public String getTitle() {
        return "Peer Control - " + this.peer.toString();
    }
}

