/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.api.Convex;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.WalletEntry;
import convex.core.data.Address;
import convex.gui.components.ActionPanel;
import convex.gui.components.ScrollyList;
import convex.gui.components.WalletComponent;
import convex.gui.manager.PeerGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)WalletPanel.class.getName());
    public static WalletEntry HERO;
    private static DefaultListModel<WalletEntry> listModel;
    ScrollyList<WalletEntry> walletList;

    public static void addWalletEntry(WalletEntry we) {
        listModel.addElement(we);
    }

    public WalletPanel() {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel toolBar = new ActionPanel();
        this.add((Component)toolBar, "South");
        JButton btnNew = new JButton("New");
        toolBar.add(btnNew);
        btnNew.addActionListener(e -> {
            Convex convex = PeerGUI.getDefaultConvex();
            AKeyPair newKP = AKeyPair.generate();
            try {
                Address addr = convex.createAccountSync(newKP.getAccountKey());
                listModel.addElement(WalletEntry.create((Address)addr, (AKeyPair)newKP));
            }
            catch (Throwable t) {
                log.warn("Exception creating account: ", t);
            }
        });
        this.walletList = new ScrollyList<WalletEntry>(listModel, we -> new WalletComponent((WalletEntry)we));
        this.add(this.walletList, "Center");
    }

    public static ListModel<WalletEntry> getListModel() {
        return listModel;
    }

    static {
        listModel = new DefaultListModel();
    }
}

