/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.WalletEntry;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerComponent;
import convex.gui.components.ScrollyList;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.mainpanels.WalletPanel;
import convex.peer.API;
import convex.peer.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeersListPanel
extends JPanel {
    JPanel peersPanel;
    JPanel peerViewPanel;
    JScrollPane scrollPane;
    private static final Logger log = LoggerFactory.getLogger((String)PeersListPanel.class.getName());

    public void launchAllPeers(PeerGUI manager) {
        block3: {
            try {
                int N = PeerGUI.KEYPAIRS.size();
                List serverList = API.launchLocalPeers(PeerGUI.KEYPAIRS, (State)PeerGUI.genesisState);
                for (Server server : serverList) {
                    ConvexLocal convex = Convex.connect((Server)server, (Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
                    this.addPeer((Convex)convex);
                    WalletEntry we = WalletEntry.create((Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
                    WalletPanel.addWalletEntry(we);
                }
            }
            catch (Exception e) {
                if (e instanceof ClosedChannelException) break block3;
                throw e;
            }
        }
    }

    public void launchPeer(PeerGUI manager) {
        AKeyPair kp = AKeyPair.generate();
        try {
            Server base = PeersListPanel.getFirst().getLocalServer();
            ConvexLocal convex = Convex.connect((Server)base, (Address)base.getPeerController(), (AKeyPair)base.getKeyPair());
            Address a = convex.createAccountSync(kp.getAccountKey());
            convex.transferSync(a, 1000000000000000L);
            WalletPanel.addWalletEntry(WalletEntry.create((Address)a, (AKeyPair)kp));
            convex = Convex.connect((Server)base, (Address)a, (AKeyPair)kp);
            AccountKey key = kp.getAccountKey();
            Result rcr = convex.transactSync("(create-peer " + key + " 10000000000000)");
            if (rcr.isError()) {
                log.warn("Error creating peer: " + rcr);
            }
            HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
            config.put(Keywords.KEYPAIR, kp);
            config.put(Keywords.CONTROLLER, a);
            config.put(Keywords.STATE, PeerGUI.genesisState);
            Server server = API.launchPeer(config);
            server.getConnectionManager().connectToPeer(base.getHostAddress());
            server.setHostname("localhost:" + server.getPort());
            base.getConnectionManager().connectToPeer(server.getHostAddress());
            convex = Convex.connect((Server)server, (Address)a, (AKeyPair)kp);
            this.addPeer((Convex)convex);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Convex getFirst() {
        return PeerGUI.peerList.elementAt(0);
    }

    public List<Convex> getPeerViews() {
        ArrayList<Convex> al = new ArrayList<Convex>();
        int n = PeerGUI.peerList.getSize();
        for (int i = 0; i < n; ++i) {
            Convex p = PeerGUI.peerList.getElementAt(i);
            al.add(p);
        }
        return al;
    }

    private void addPeer(Convex convex) {
        PeerGUI.peerList.addElement(convex);
    }

    public PeersListPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel toolBar = new ActionPanel();
        this.add((Component)toolBar, "South");
        JButton btnLaunch = new JButton("Launch!");
        toolBar.add(btnLaunch);
        btnLaunch.addActionListener(e -> this.launchPeer(manager));
        JButton btnConnect = new JButton("Connect...");
        toolBar.add(btnConnect);
        btnConnect.addActionListener(e -> {
            String input = JOptionPane.showInputDialog("Enter host address: ", (Object)"localhost:18888");
            if (input == null) {
                return;
            }
            String[] ss = input.split(":");
            String host = ss[0].trim();
            int port = ss.length > 1 ? Integer.parseInt(ss[1].trim()) : 0;
            InetSocketAddress hostAddress = new InetSocketAddress(host, port);
            try {
                ConvexRemote pc = Convex.connect((InetSocketAddress)hostAddress, null, null);
                this.addPeer((Convex)pc);
            }
            catch (Throwable e1) {
                JOptionPane.showMessageDialog(this, "Connect failed: " + e1.toString());
            }
        });
        ScrollyList<Convex> scrollyList = new ScrollyList<Convex>(PeerGUI.peerList, peer -> new PeerComponent(manager, (Convex)peer));
        this.add(scrollyList, "Center");
    }

    public void closePeers() {
        int n = PeerGUI.peerList.getSize();
        for (int i = 0; i < n; ++i) {
            Convex p = PeerGUI.peerList.getElementAt(i);
            try {
                p.getLocalServer().close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

