/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.core.State;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.gui.components.ActionPanel;
import convex.gui.components.models.AccountsTableModel;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.windows.actor.ActorWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AccountsPanel
extends JPanel {
    AccountsTableModel tableModel = new AccountsTableModel(PeerGUI.getLatestState());
    JTable table = new JTable(this.tableModel);

    public AccountsPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout());
        PeerGUI.getStateModel().addPropertyChangeListener(pc -> {
            State newState = (State)pc.getNewValue();
            this.tableModel.setState(newState);
        });
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.table.getColumnModel().getColumn(0).setCellRenderer(leftRenderer);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        ActorRenderer actorRenderer = new ActorRenderer();
        actorRenderer.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setCellRenderer(actorRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(rightRenderer);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(3).setCellRenderer(rightRenderer);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(4).setCellRenderer(leftRenderer);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(5).setCellRenderer(rightRenderer);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(6).setCellRenderer(rightRenderer);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(7).setCellRenderer(rightRenderer);
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem("Copy Address");
        copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountsPanel.this.copyAddress();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int r = AccountsPanel.this.table.rowAtPoint(e.getPoint());
                if (r >= 0 && r < AccountsPanel.this.table.getRowCount()) {
                    AccountsPanel.this.table.setRowSelectionInterval(r, r);
                } else {
                    AccountsPanel.this.table.clearSelection();
                }
                if (e.isPopupTrigger() || (e.getButton() & 3) > 0) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        JButton btnCopy = new JButton("Copy Address");
        actionPanel.add(btnCopy);
        btnCopy.addActionListener(e -> this.copyAddress());
        JButton btnActor = new JButton("Examine Actor...");
        actionPanel.add(btnActor);
        btnActor.addActionListener(e -> {
            long ix = this.table.getSelectedRow();
            AccountStatus as = this.tableModel.getEntry(ix);
            if (as == null) {
                return;
            }
            Address addr = Address.create((long)ix);
            if (!as.isActor()) {
                return;
            }
            ActorWindow pw = new ActorWindow(manager, addr);
            pw.launch();
        });
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(null);
        this.add((Component)scrollPane, "Center");
        this.table.setFont(convex.gui.utils.Toolkit.SMALL_MONO_FONT);
        this.table.getTableHeader().setFont(convex.gui.utils.Toolkit.SMALL_MONO_FONT);
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    private void copyAddress() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        Address addr = Address.create((long)row);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(addr.toHexString());
        clipboard.setContents(stringSelection, null);
    }

    static class ActorRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value.toString());
        }
    }
}

