/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.crypto.WalletEntry;
import convex.core.data.ABlob;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.util.Text;
import convex.gui.client.ConvexClient;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.DropdownMenu;
import convex.gui.components.Identicon;
import convex.gui.components.UnlockWalletDialog;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletComponent
extends BaseListComponent {
    private static final Logger log = LoggerFactory.getLogger((String)WalletComponent.class.getName());
    Icon icon = Toolkit.LOCKED_ICON;
    JButton lockButton;
    JButton replButton;
    WalletEntry walletEntry;
    JPanel buttons = new JPanel();
    private Address address;

    public WalletComponent(WalletEntry initialWalletEntry) {
        this.walletEntry = initialWalletEntry;
        this.address = this.walletEntry.getAddress();
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        Identicon identicon = new Identicon((ABlob)this.walletEntry.getIdenticonHash());
        JPanel idPanel = new JPanel();
        idPanel.add(identicon);
        this.add((Component)idPanel, "west");
        JPanel cPanel = new JPanel();
        cPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        CodeLabel addressLabel = new CodeLabel(this.address.toString());
        addressLabel.setFont(Toolkit.MONO_FONT);
        cPanel.add((Component)addressLabel, "span");
        CodeLabel infoLabel = new CodeLabel(this.getInfoString());
        cPanel.add((Component)infoLabel, "span,growx");
        this.add((Component)cPanel, "grow,shrink");
        PeerGUI.getStateModel().addPropertyChangeListener(e -> infoLabel.setText(this.getInfoString()));
        this.replButton = new JButton("");
        this.buttons.add(this.replButton);
        this.replButton.setIcon(Toolkit.REPL_ICON);
        this.replButton.addActionListener(e -> {
            ConvexClient c = ConvexClient.launch(PeerGUI.connectClient(this.walletEntry.getAddress(), this.walletEntry.getKeyPair()));
            c.tabs.setSelectedComponent(c.replPanel);
        });
        this.replButton.setToolTipText("Launch a client REPL for this account");
        this.lockButton = new JButton("");
        this.buttons.add(this.lockButton);
        this.lockButton.setIcon(this.walletEntry.isLocked() ? Toolkit.LOCKED_ICON : Toolkit.UNLOCKED_ICON);
        this.resetTooltipTExt(this.lockButton);
        this.lockButton.addActionListener(e -> {
            if (this.walletEntry.isLocked()) {
                UnlockWalletDialog dialog = UnlockWalletDialog.show(this);
                char[] passPhrase = dialog.getPassPhrase();
                try {
                    this.walletEntry = this.walletEntry.unlock(passPhrase);
                    this.icon = Toolkit.UNLOCKED_ICON;
                }
                catch (Throwable e1) {
                    JOptionPane.showMessageDialog(this, "Unable to unlock wallet: " + e1.getMessage());
                }
            } else {
                try {
                    this.walletEntry = this.walletEntry.lock();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.icon = Toolkit.LOCKED_ICON;
            }
            this.resetTooltipTExt(this.lockButton);
            this.lockButton.setIcon(this.icon);
        });
        JPopupMenu menu = new JPopupMenu();
        JMenuItem m1 = new JMenuItem("Edit...");
        menu.add(m1);
        DropdownMenu menuButton = new DropdownMenu(menu);
        this.buttons.add(menuButton);
        this.add((Component)this.buttons, "east");
    }

    private void resetTooltipTExt(JComponent b) {
        if (this.walletEntry.isLocked()) {
            b.setToolTipText("Unlock");
        } else {
            b.setToolTipText("Lock");
        }
    }

    private String getInfoString() {
        StringBuilder sb = new StringBuilder();
        PeerGUI.runWithLatestState(s -> {
            AccountStatus as = s.getAccount(this.address);
            if (as != null) {
                Long bal = as.getBalance();
                sb.append("Balance: " + (bal == null ? "Null" : Text.toFriendlyNumber((long)bal)));
            }
        });
        return sb.toString();
    }
}

