/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.client;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.util.Utils;
import convex.gui.client.panels.HomePanel;
import convex.gui.manager.mainpanels.AboutPanel;
import convex.gui.manager.mainpanels.WalletPanel;
import convex.gui.manager.windows.peer.REPLPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexClient
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)ConvexClient.class.getName());
    private static JFrame frame;
    public static long maxBlock;
    static boolean clientMode;
    protected Convex convex = null;
    JPanel panel = new JPanel();
    HomePanel homePanel = new HomePanel();
    AboutPanel aboutPanel = new AboutPanel();
    public JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();
    WalletPanel walletPanel = new WalletPanel();
    public REPLPanel replPanel;

    public static void main(String[] args) throws IOException, TimeoutException {
        log.info("Running Convex Client");
        clientMode = true;
        Toolkit.init();
        String DEFAULT = "localhost:18888";
        String hostAddress = JOptionPane.showInputDialog("Enter Peer Address (default to " + DEFAULT + ")");
        if (hostAddress.isBlank()) {
            hostAddress = DEFAULT;
        }
        ConvexRemote convex = Convex.connect((InetSocketAddress)Utils.toInetSocketAddress((String)hostAddress));
        EventQueue.invokeLater(() -> ConvexClient.lambda$main$0((Convex)convex));
    }

    public ConvexClient(Convex convex) {
        this.setLayout(new BorderLayout());
        this.replPanel = new REPLPanel(convex);
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Home", this.homePanel);
        this.tabs.add("About", this.aboutPanel);
        this.tabs.add("Wallet", this.walletPanel);
        this.tabs.add("REPL", this.replPanel);
        this.convex = convex;
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    public static Component getFrame() {
        return frame;
    }

    public static ConvexClient launch(Convex convex) {
        try {
            frame = new JFrame();
            frame.setTitle("Convex Client - " + convex);
            frame.setIconImage(Toolkit.getImage(ConvexClient.class.getResource("/images/Convex.png")));
            frame.setBounds(100, 100, 1024, 768);
            if (clientMode) {
                frame.setDefaultCloseOperation(3);
            }
            ConvexClient window = new ConvexClient(convex);
            frame.getContentPane().add((Component)window, "Center");
            frame.pack();
            frame.setVisible(true);
            return window;
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$main$0(Convex convex) {
        ConvexClient.launch(convex);
    }

    static {
        maxBlock = 0L;
        clientMode = false;
    }
}

