/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Strings;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.transactions.Multi;
import convex.core.util.Text;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerView;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressPanel
extends JPanel {
    static final Logger log = LoggerFactory.getLogger((String)StressPanel.class.getName());
    protected PeerView peerView;
    private ActionPanel actionPanel;
    private JButton btnRun;
    private JSpinner requestCountSpinner;
    private JSpinner transactionCountSpinner;
    private JSpinner opCountSpinner;
    private JSpinner clientCountSpinner;
    private JCheckBox syncCheckBox;
    long errors = 0L;
    long values = 0L;
    private JSplitPane splitPane;
    private JPanel resultPanel;
    private JTextArea resultArea;
    NumberFormat formatter = new DecimalFormat("#0.000");

    public StressPanel(PeerView peerView) {
        this.peerView = peerView;
        this.setLayout(new BorderLayout());
        this.actionPanel = new ActionPanel();
        this.add((Component)this.actionPanel, "South");
        this.btnRun = new JButton("Run Test");
        this.actionPanel.add(this.btnRun);
        this.btnRun.addActionListener(e -> {
            this.btnRun.setEnabled(false);
            SwingUtilities.invokeLater(() -> this.runStressTest());
        });
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        JPanel panel = new JPanel();
        this.splitPane.setLeftComponent(panel);
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setAlignOnBaseline(true);
        JPanel optionPanel = new JPanel();
        panel.add(optionPanel);
        optionPanel.setLayout(new GridLayout(0, 2, 0, 0));
        JLabel lblClients = new JLabel("Clients");
        optionPanel.add(lblClients);
        this.clientCountSpinner = new JSpinner();
        this.clientCountSpinner.setModel(new SpinnerNumberModel(100, 1, 300, 1));
        optionPanel.add(this.clientCountSpinner);
        JLabel lblRequests = new JLabel("Requests per client");
        optionPanel.add(lblRequests);
        this.requestCountSpinner = new JSpinner();
        this.requestCountSpinner.setModel(new SpinnerNumberModel(100, 1, 1000, 10));
        optionPanel.add(this.requestCountSpinner);
        JLabel lblTrans = new JLabel("Transactions per Request");
        optionPanel.add(lblTrans);
        this.transactionCountSpinner = new JSpinner();
        this.transactionCountSpinner.setModel(new SpinnerNumberModel(10, 1, 1000, 1));
        optionPanel.add(this.transactionCountSpinner);
        JLabel lblOps = new JLabel("Ops per Transaction");
        optionPanel.add(lblOps);
        this.opCountSpinner = new JSpinner();
        this.opCountSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 10));
        optionPanel.add(this.opCountSpinner);
        JLabel lblSync = new JLabel("Sync Requests?");
        optionPanel.add(lblSync);
        this.syncCheckBox = new JCheckBox();
        optionPanel.add(this.syncCheckBox);
        this.syncCheckBox.setSelected(true);
        this.resultPanel = new JPanel();
        this.splitPane.setRightComponent(this.resultPanel);
        this.resultPanel.setLayout(new BorderLayout(0, 0));
        this.resultArea = new JTextArea();
        this.resultArea.setText("No results yet");
        this.resultArea.setLineWrap(true);
        this.resultArea.setEditable(false);
        this.resultPanel.add(this.resultArea);
        this.resultArea.setFont(Toolkit.SMALL_MONO_FONT);
    }

    private synchronized void runStressTest() {
        this.errors = 0L;
        this.values = 0L;
        final Address address = PeerGUI.getGenesisAddress();
        final int transCount = (Integer)this.transactionCountSpinner.getValue();
        final int requestCount = (Integer)this.requestCountSpinner.getValue();
        final int opCount = (Integer)this.opCountSpinner.getValue();
        final int clientCount = (Integer)this.clientCountSpinner.getValue();
        new SwingWorker<String, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String doInBackground() throws Exception {
                StringBuilder sb = new StringBuilder();
                try {
                    StressPanel.this.resultArea.setText("Connecting clients...");
                    InetSocketAddress sa = StressPanel.this.peerView.peerServer.getHostAddress();
                    ArrayList frs = new ArrayList();
                    ConvexRemote pc = Convex.connect((InetSocketAddress)sa, (Address)address, (AKeyPair)PeerGUI.getUserKeyPair(0));
                    ArrayList<AKeyPair> kps = new ArrayList<AKeyPair>(clientCount);
                    for (int i = 0; i < clientCount; ++i) {
                        kps.add(AKeyPair.generate());
                    }
                    StringBuilder cmdsb = new StringBuilder();
                    cmdsb.append("(mapv (fn [k] (let [a (create-account k)] (transfer a 1000000000) a)) [");
                    for (int i = 0; i < clientCount; ++i) {
                        cmdsb.append(" " + ((AKeyPair)kps.get(i)).getAccountKey());
                    }
                    cmdsb.append("])");
                    Result ccr = pc.transactSync((ATransaction)Invoke.create((Address)address, (long)-1L, (String)cmdsb.toString()));
                    if (ccr.isError()) {
                        throw new Error("Creating accounts failed: " + ccr);
                    }
                    AVector v = (AVector)ccr.getValue();
                    ArrayList<ConvexRemote> ccs = new ArrayList<ConvexRemote>(clientCount);
                    for (int i = 0; i < clientCount; ++i) {
                        AKeyPair kp = (AKeyPair)kps.get(i);
                        Address clientAddr = (Address)v.get(i);
                        ConvexRemote cc2 = Convex.connect((InetSocketAddress)sa, (Address)clientAddr, (AKeyPair)kp);
                        ccs.add(cc2);
                    }
                    StressPanel.this.resultArea.setText("Syncing...");
                    pc.transactSync((ATransaction)Invoke.create((Address)address, (long)-1L, (ACell)Strings.create((String)"sync")));
                    long startTime = Utils.getCurrentTimestamp();
                    StressPanel.this.resultArea.setText("Sending transactions...");
                    ArrayList cfutures = Utils.threadMap(cc -> {
                        try {
                            for (int i = 0; i < requestCount; ++i) {
                                CompletableFuture<Result> fr;
                                StringBuilder tsb = new StringBuilder();
                                tsb.append("(def a (do ");
                                for (int j = 0; j < opCount; ++j) {
                                    tsb.append(" (* 10 " + i + ")");
                                }
                                tsb.append("))");
                                String source = tsb.toString();
                                Address origin = cc.getAddress();
                                Invoke t = Invoke.create((Address)origin, (long)-1L, (ACell)Reader.read((String)source));
                                if (transCount != 1) {
                                    ATransaction[] trxs = new ATransaction[transCount];
                                    for (int k = 0; k < transCount; ++k) {
                                        trxs[k] = t;
                                    }
                                    t = Multi.create((Address)origin, (long)-1L, (int)0, (ATransaction[])trxs);
                                }
                                if (StressPanel.this.syncCheckBox.isSelected()) {
                                    Result r = cc.transactSync((ATransaction)t);
                                    fr = CompletableFuture.completedFuture(r);
                                } else {
                                    fr = cc.transact((ATransaction)t);
                                }
                                ArrayList arrayList = frs;
                                synchronized (arrayList) {
                                    frs.add(fr);
                                    continue;
                                }
                            }
                        }
                        catch (Exception e) {
                            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                        }
                        return null;
                    }, ccs);
                    for (int i = 0; i < clientCount; ++i) {
                        ((CompletableFuture)cfutures.get(i)).get(60L, TimeUnit.SECONDS);
                    }
                    int futureCount = frs.size();
                    StressPanel.this.resultArea.setText("Awaiting " + futureCount + " results...");
                    List results = (List)Utils.completeAll(frs).get(60L, TimeUnit.SECONDS);
                    long endTime = Utils.getCurrentTimestamp();
                    HashMap errorMap = new HashMap();
                    for (Result r : results) {
                        if (r.isError()) {
                            ++StressPanel.this.errors;
                            Utils.histogramAdd(errorMap, (Object)r.getErrorCode());
                            continue;
                        }
                        ++StressPanel.this.values;
                    }
                    for (int i = 0; i < clientCount; ++i) {
                        ((Convex)ccs.get(i)).close();
                    }
                    Thread.sleep(100L);
                    long totalCount = clientCount * transCount * requestCount;
                    sb.append("Results for " + Text.toFriendlyNumber((long)totalCount) + " transactions\n");
                    sb.append(StressPanel.this.values + " values received\n");
                    sb.append(StressPanel.this.errors + " errors received\n");
                    if (StressPanel.this.errors > 0L) {
                        sb.append(errorMap);
                        sb.append("\n");
                    }
                    sb.append("\n");
                    sb.append("Total time:     " + StressPanel.this.formatter.format((double)(endTime - startTime) * 0.001) + "s\n");
                    sb.append("\n");
                    sb.append("Approx TPS:     " + Text.toFriendlyIntString((double)((double)totalCount / ((double)(endTime - startTime) * 0.001))) + "\n");
                }
                catch (IOException e) {
                    log.warn("Stress test worker terminated from IO Exception");
                }
                catch (Throwable e) {
                    log.warn("Stress test worker terminated unexpectedly", e);
                }
                finally {
                    StressPanel.this.btnRun.setEnabled(true);
                }
                String report = sb.toString();
                return report;
            }

            @Override
            protected void done() {
                try {
                    StressPanel.this.resultArea.setText((String)this.get());
                }
                catch (Exception e) {
                    StressPanel.this.resultArea.setText(e.getMessage());
                }
            }
        }.execute();
    }
}

