/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.State;
import convex.core.crypto.WalletEntry;
import convex.core.data.Address;
import convex.core.util.Text;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.mainpanels.WalletPanel;
import java.awt.FlowLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class AccountChooserPanel
extends JPanel {
    private JComboBox<String> modeCombo;
    public JComboBox<WalletEntry> addressCombo;
    private JLabel lblNewLabel_1;
    private JLabel lblNewLabel;
    private ComboBoxModel<WalletEntry> addressModel = this.createAddressList(WalletPanel.getListModel());
    private JLabel balanceLabel;

    public AccountChooserPanel() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
        this.modeCombo = new JComboBox();
        this.modeCombo.setToolTipText("Use Transact to execute transactions (uses cash).\n\nUse Query to compute results without changing on-chain state (free).");
        this.modeCombo.addItem("Transact");
        this.modeCombo.addItem("Query");
        this.lblNewLabel_1 = new JLabel("Mode:");
        this.add(this.lblNewLabel_1);
        this.add(this.modeCombo);
        this.lblNewLabel = new JLabel("Account:");
        this.add(this.lblNewLabel);
        this.addressCombo = new JComboBox();
        this.addressCombo.setEditable(false);
        this.add(this.addressCombo);
        this.addressCombo.setModel(this.addressModel);
        this.balanceLabel = new JLabel("Balance: ");
        this.add(this.balanceLabel);
        PeerGUI.getStateModel().addPropertyChangeListener(pc -> this.updateBalance((State)pc.getNewValue(), this.getSelectedAddress()));
        this.addressCombo.addItemListener(e -> this.updateBalance(PeerGUI.getLatestState(), this.getSelectedAddress()));
        this.updateBalance(PeerGUI.getLatestState(), this.getSelectedAddress());
    }

    public Address getSelectedAddress() {
        WalletEntry we = (WalletEntry)this.addressModel.getSelectedItem();
        return we == null ? null : we.getAddress();
    }

    private ComboBoxModel<WalletEntry> createAddressList(ListModel<WalletEntry> m) {
        int n = m.getSize();
        DefaultComboBoxModel<WalletEntry> cm = new DefaultComboBoxModel<WalletEntry>();
        for (int i = 0; i < n; ++i) {
            WalletEntry we = m.getElementAt(i);
            cm.addElement(we);
        }
        cm.addElement(null);
        return cm;
    }

    private void updateBalance(State s, Address a) {
        if (s == null || a == null) {
            this.balanceLabel.setText("Balance: <not available>");
        } else {
            Long amt = s.getBalance(a);
            this.balanceLabel.setText("Balance: " + (amt == null ? "Null" : Text.toFriendlyNumber((long)amt)));
        }
    }

    public String getMode() {
        return (String)this.modeCombo.getSelectedItem();
    }

    public WalletEntry getWalletEntry() {
        return (WalletEntry)this.addressCombo.getSelectedItem();
    }
}

