/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.peer;

import convex.api.Convex;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Strings;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerView;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class StressPanel
extends JPanel {
    protected PeerView peerView;
    private ActionPanel actionPanel;
    private JButton btnRun;
    private JSpinner transactionCountSpinner;
    private JSpinner opCountSpinner;
    private JSpinner clientCountSpinner;
    long errors = 0L;
    long values = 0L;
    private JSplitPane splitPane;
    private JPanel resultPanel;
    private JTextArea resultArea;
    NumberFormat formatter = new DecimalFormat("#0.000");

    public StressPanel(PeerView peerView) {
        this.peerView = peerView;
        this.setLayout(new BorderLayout());
        this.actionPanel = new ActionPanel();
        this.add((Component)this.actionPanel, "South");
        this.btnRun = new JButton("Run Test");
        this.actionPanel.add(this.btnRun);
        this.btnRun.addActionListener(e -> {
            this.btnRun.setEnabled(false);
            SwingUtilities.invokeLater(() -> this.runStressTest());
        });
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        JPanel panel = new JPanel();
        this.splitPane.setLeftComponent(panel);
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setAlignOnBaseline(true);
        JPanel optionPanel = new JPanel();
        panel.add(optionPanel);
        optionPanel.setLayout(new GridLayout(0, 2, 0, 0));
        JLabel lblNewLabel = new JLabel("Transactions per client");
        optionPanel.add(lblNewLabel);
        this.transactionCountSpinner = new JSpinner();
        this.transactionCountSpinner.setModel(new SpinnerNumberModel(1000, 1, 1000000, 100));
        optionPanel.add(this.transactionCountSpinner);
        JLabel lblNewLabel2 = new JLabel("Ops per Transaction");
        optionPanel.add(lblNewLabel2);
        this.opCountSpinner = new JSpinner();
        this.opCountSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 10));
        optionPanel.add(this.opCountSpinner);
        JLabel lblNewLabel3 = new JLabel("Clients");
        optionPanel.add(lblNewLabel3);
        this.clientCountSpinner = new JSpinner();
        this.clientCountSpinner.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        optionPanel.add(this.clientCountSpinner);
        this.resultPanel = new JPanel();
        this.splitPane.setRightComponent(this.resultPanel);
        this.resultPanel.setLayout(new BorderLayout(0, 0));
        this.resultArea = new JTextArea();
        this.resultArea.setText("No results yet");
        this.resultArea.setLineWrap(true);
        this.resultArea.setEditable(false);
        this.resultPanel.add(this.resultArea);
        this.resultArea.setFont(Toolkit.SMALL_MONO_FONT);
    }

    private synchronized void runStressTest() {
        this.errors = 0L;
        this.values = 0L;
        final Address address = PeerGUI.getGenesisAddress();
        final int transCount = (Integer)this.transactionCountSpinner.getValue();
        final int opCount = (Integer)this.opCountSpinner.getValue();
        final int clientCount = (Integer)this.clientCountSpinner.getValue();
        new SwingWorker<String, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String doInBackground() throws Exception {
                StringBuilder sb = new StringBuilder();
                try {
                    InetSocketAddress sa = StressPanel.this.peerView.peerServer.getHostAddress();
                    ArrayList frs = new ArrayList();
                    Convex pc = Convex.connect((InetSocketAddress)sa, (Address)address, (AKeyPair)PeerGUI.getUserKeyPair(0));
                    ArrayList<AKeyPair> kps = new ArrayList<AKeyPair>(clientCount);
                    for (int i = 0; i < clientCount; ++i) {
                        kps.add(AKeyPair.generate());
                    }
                    StringBuilder cmdsb = new StringBuilder();
                    cmdsb.append("[");
                    for (int i = 0; i < clientCount; ++i) {
                        cmdsb.append("(let [a (create-account " + ((AKeyPair)kps.get(i)).getAccountKey() + ")] (transfer a 1000000000) a)");
                    }
                    cmdsb.append("]");
                    AVector v = (AVector)pc.transactSync((ATransaction)Invoke.create((Address)address, (long)-1L, (String)cmdsb.toString())).getValue();
                    ArrayList<Convex> ccs = new ArrayList<Convex>(clientCount);
                    for (int i = 0; i < clientCount; ++i) {
                        AKeyPair kp = (AKeyPair)kps.get(i);
                        Address clientAddr = (Address)v.get(i);
                        Convex cc2 = Convex.connect((InetSocketAddress)sa, (Address)clientAddr, (AKeyPair)kp);
                        ccs.add(cc2);
                    }
                    pc.transactSync((ATransaction)Invoke.create((Address)address, (long)-1L, (ACell)Strings.create((String)"sync")));
                    long startTime = Utils.getCurrentTimestamp();
                    ArrayList cfutures = Utils.futureMap(cc -> {
                        try {
                            for (int i = 0; i < transCount; ++i) {
                                StringBuilder tsb = new StringBuilder();
                                tsb.append("(def a (do ");
                                for (int j = 0; j < opCount; ++j) {
                                    tsb.append(" (* 10 " + i + ")");
                                }
                                tsb.append("))");
                                String source = tsb.toString();
                                Invoke t = Invoke.create((Address)cc.getAddress(), (long)-1L, (ACell)Reader.read((String)source));
                                CompletableFuture fr = cc.transact((ATransaction)t);
                                frs.add(fr);
                            }
                        }
                        catch (IOException e) {
                            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                        }
                        return null;
                    }, ccs);
                    for (int i = 0; i < clientCount; ++i) {
                        ((Future)cfutures.get(i)).get(60L, TimeUnit.SECONDS);
                    }
                    long sendTime = Utils.getCurrentTimestamp();
                    List results = (List)Utils.completeAll(frs).get(60L, TimeUnit.SECONDS);
                    long endTime = Utils.getCurrentTimestamp();
                    for (Result r : results) {
                        if (r.isError()) {
                            ++StressPanel.this.errors;
                            continue;
                        }
                        ++StressPanel.this.values;
                    }
                    for (int i = 0; i < clientCount; ++i) {
                        ((Convex)ccs.get(i)).close();
                    }
                    Thread.sleep(100L);
                    State endState = PeerGUI.getLatestState();
                    sb.append("Results for " + transCount + " transactions\n");
                    sb.append(StressPanel.this.values + " values received\n");
                    sb.append(StressPanel.this.errors + " errors received\n");
                    sb.append("\n");
                    sb.append("Send time:     " + StressPanel.this.formatter.format((double)(sendTime - startTime) * 0.001) + "s\n");
                    sb.append("End time:      " + StressPanel.this.formatter.format((double)(endTime - startTime) * 0.001) + "s\n");
                    sb.append("Consensus time: " + StressPanel.this.formatter.format((double)(endState.getTimeStamp().longValue() - startTime) * 0.001) + "s\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    StressPanel.this.btnRun.setEnabled(true);
                }
                String report = sb.toString();
                return report;
            }

            @Override
            protected void done() {
                try {
                    StressPanel.this.resultArea.setText((String)this.get());
                }
                catch (Exception e) {
                    StressPanel.this.resultArea.setText(e.getMessage());
                }
            }
        }.execute();
    }
}

