/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;

public class StateModel<T> {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    T value;

    public StateModel(T value) {
        this.value = value;
    }

    public StateModel() {
        this(null);
    }

    public static <T> StateModel<T> create(T value) {
        return new StateModel<T>(value);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(final T newValue) {
        final T oldValue = this.value;
        this.value = newValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StateModel.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "value", oldValue, newValue));
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

