/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.peer;

import convex.api.Convex;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.WalletEntry;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.gui.components.AccountChooserPanel;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REPLPanel
extends JPanel {
    JTextArea inputArea;
    JTextArea outputArea;
    private JButton btnClear;
    private JButton btnInfo;
    private ArrayList<String> history = new ArrayList();
    private int historyPosition = 0;
    private InputListener inputListener = new InputListener();
    private JPanel panel_1;
    private AccountChooserPanel execPanel = new AccountChooserPanel();
    private final Convex convex;
    private static final Logger log = LoggerFactory.getLogger((String)REPLPanel.class.getName());

    public void setInput(String s) {
        this.inputArea.setText(s);
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.inputArea.requestFocusInWindow();
        }
    }

    protected void handleResult(Result r) {
        if (r.isError()) {
            this.handleError(r.getErrorCode(), r.getValue(), (AVector<AString>)r.getTrace());
        } else {
            this.handleResult(r.getValue());
        }
    }

    protected void handleResult(Object m) {
        this.outputArea.append(" => " + m + "\n");
        this.outputArea.setCaretPosition(this.outputArea.getDocument().getLength());
    }

    protected void handleError(Object code, Object msg, AVector<AString> trace) {
        this.outputArea.append(" Exception: " + code + " " + msg + "\n");
        if (trace != null) {
            for (AString s : trace) {
                this.outputArea.append(" - " + s.toString() + "\n");
            }
        }
    }

    public REPLPanel(PeerView peerView) {
        this.setLayout(new BorderLayout(0, 0));
        InetSocketAddress addr = peerView.getHostAddress();
        if (addr == null) {
            JOptionPane.showMessageDialog(this, "Error: peer shut down already?");
            throw new Error("Connect fail, no remote address");
        }
        try {
            this.convex = Convex.connect((InetSocketAddress)addr, (Address)this.getAddress(), (AKeyPair)this.getKeyPair());
        }
        catch (Exception ex) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)ex);
        }
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.8);
        splitPane.setOneTouchExpandable(true);
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        this.outputArea = new JTextArea();
        this.outputArea.setRows(15);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setFont(new Font("Monospaced", 0, 13));
        splitPane.setLeftComponent(new JScrollPane(this.outputArea));
        this.inputArea = new JTextArea();
        this.inputArea.setRows(5);
        this.inputArea.setFont(new Font("Monospaced", 0, 13));
        this.inputArea.getDocument().addDocumentListener(this.inputListener);
        this.inputArea.addKeyListener(this.inputListener);
        splitPane.setRightComponent(new JScrollPane(this.inputArea));
        this.setFocusTraversalKeysEnabled(false);
        this.inputArea.setFocusTraversalKeysEnabled(false);
        this.add((Component)this.execPanel, "North");
        this.panel_1 = new ActionPanel();
        this.add((Component)this.panel_1, "South");
        this.btnClear = new JButton("Clear");
        this.panel_1.add(this.btnClear);
        this.btnClear.addActionListener(e -> this.outputArea.setText(""));
        this.btnInfo = new JButton("Connection Info");
        this.panel_1.add(this.btnInfo);
        this.btnInfo.addActionListener(e -> {
            Object infoString = "";
            infoString = (String)infoString + "Remote host:  " + this.convex.getRemoteAddress() + "\n";
            infoString = (String)infoString + "Sequence:  " + this.convex.getSequence() + "\n";
            infoString = (String)infoString + "Connection Account:  " + this.convex.getAddress() + "\n";
            JOptionPane.showMessageDialog(this, infoString);
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                REPLPanel.this.inputArea.requestFocusInWindow();
            }
        });
    }

    private AKeyPair getKeyPair() {
        WalletEntry we = this.execPanel.getWalletEntry();
        if (we == null) {
            return null;
        }
        return we.getKeyPair();
    }

    private Address getAddress() {
        WalletEntry we = this.execPanel.getWalletEntry();
        return we.getAddress();
    }

    private void sendMessage(String s) {
        if (s.isBlank()) {
            return;
        }
        this.history.add(s);
        this.historyPosition = this.history.size();
        SwingUtilities.invokeLater(() -> {
            this.outputArea.append(s);
            this.outputArea.append("\n");
            try {
                Future future;
                AList forms = Reader.readAll((String)s);
                ACell message = forms.count() == 1L ? forms.get(0) : forms.cons((ACell)Symbols.DO);
                String mode = this.execPanel.getMode();
                if (mode.equals("Query")) {
                    AKeyPair kp = this.getKeyPair();
                    future = kp == null ? this.convex.query(message, null) : this.convex.query(message, this.getAddress());
                } else if (mode.equals("Transact")) {
                    WalletEntry we = this.execPanel.getWalletEntry();
                    if (we == null || we.isLocked()) {
                        JOptionPane.showMessageDialog(this, "Please select an address to use for transactions before sending");
                        return;
                    }
                    Address address = this.getAddress();
                    Invoke trans = Invoke.create((Address)address, (long)-1L, (ACell)message);
                    future = this.convex.transact((ATransaction)trans);
                } else {
                    throw new Error("Unrecognosed REPL mode: " + mode);
                }
                log.trace("Sent message");
                this.handleResult((Result)future.get(5000L, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException t) {
                this.outputArea.append(" TIMEOUT waiting for result");
            }
            catch (Throwable t) {
                this.outputArea.append(" SEND ERROR: ");
                this.outputArea.append(t.getMessage() + "\n");
                t.printStackTrace();
            }
            this.inputArea.setText("");
        });
    }

    private class InputListener
    implements DocumentListener,
    KeyListener {
        private InputListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int len = e.getLength();
            int off = e.getOffset();
            String s = REPLPanel.this.inputArea.getText();
            if (len == 1 && len + off == s.length() && s.charAt(off) == '\n') {
                REPLPanel.this.sendMessage(s.trim());
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                int code = e.getKeyCode();
                int hSize = REPLPanel.this.history.size();
                if (code == 38) {
                    if (REPLPanel.this.historyPosition > 0) {
                        if (REPLPanel.this.historyPosition == hSize) {
                            String s = REPLPanel.this.inputArea.getText();
                            REPLPanel.this.history.add(s);
                        }
                        --REPLPanel.this.historyPosition;
                        REPLPanel.this.setInput(REPLPanel.this.history.get(REPLPanel.this.historyPosition));
                    }
                    e.consume();
                } else if (code == 40) {
                    if (REPLPanel.this.historyPosition < hSize - 1) {
                        ++REPLPanel.this.historyPosition;
                        REPLPanel.this.setInput(REPLPanel.this.history.get(REPLPanel.this.historyPosition));
                    }
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

