/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.kad;

import convex.core.data.AArrayBlob;

public class Kademlia {
    public static int proximity(AArrayBlob a, AArrayBlob b) {
        if (a.count() != b.count()) {
            throw new IllegalArgumentException("Inconsistent key sizes");
        }
        int bits = a.size() * 8;
        int sameHex = (int)a.hexMatch(b);
        if (sameHex * 4 >= bits) {
            return bits;
        }
        int va = a.getHexDigit(sameHex);
        int vb = b.getHexDigit(sameHex);
        int prox = sameHex * 4 + Kademlia.hexProximity(va, vb);
        return prox;
    }

    private static int hexProximity(int da, int db) {
        int xor = da & 0xF ^ db & 0xF;
        return Integer.numberOfLeadingZeros(xor) - 28;
    }

    public static long distance(AArrayBlob a, AArrayBlob b) {
        try {
            long va = a.longAt(0L);
            long vb = b.longAt(0L);
            return va ^ vb;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Insufficient bytes for distance check");
        }
    }
}

