/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.generic;

import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.SignedData;
import convex.core.util.Utils;
import convex.lattice.ALattice;

public class SignedLattice<V extends ACell>
extends ALattice<SignedData<V>> {
    protected final ALattice<V> valueNode;
    private AKeyPair keyPair;

    private SignedLattice(ALattice<V> valueNode) {
        this.valueNode = valueNode;
    }

    public static <V extends ACell> SignedLattice<V> create(ALattice<V> childNode) {
        return new SignedLattice<V>(childNode);
    }

    @Override
    public SignedData<V> merge(SignedData<V> ownValue, SignedData<V> otherValue) {
        V b;
        if (otherValue == null) {
            return ownValue;
        }
        if (ownValue == null) {
            if (this.checkForeign(otherValue)) {
                return otherValue;
            }
            return null;
        }
        V a = ownValue.getValue();
        if (Utils.equals(a, b = otherValue.getValue())) {
            return ownValue;
        }
        if (!this.checkForeign(otherValue)) {
            return ownValue;
        }
        V m = this.valueNode.merge(a, b);
        if (Utils.equals(a, m)) {
            return ownValue;
        }
        if (Utils.equals(b, m)) {
            return otherValue;
        }
        return this.sign(m);
    }

    @Override
    public boolean checkForeign(SignedData<V> otherValue) {
        if (otherValue == null) {
            return false;
        }
        return otherValue.checkSignature();
    }

    private SignedData<V> sign(V m) {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            throw new IllegalStateException("Unable to sign new lattice value");
        }
        return kp.signData(m);
    }

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(AKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public SignedData<V> zero() {
        return null;
    }
}

