/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.generic;

import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AMap;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.util.Utils;
import convex.lattice.ALattice;
import java.util.ArrayList;

public class KeyedLattice
extends ALattice<AMap<Keyword, ?>> {
    private final ArrayList<ALattice<?>> lattices;
    private final ArrayList<Keyword> keys;

    private KeyedLattice(ArrayList<ALattice<?>> lattices, ArrayList<Keyword> keys) {
        this.lattices = lattices;
        this.keys = keys;
    }

    public static KeyedLattice create(Object ... keysAndValues) {
        int n2 = keysAndValues.length;
        int n = n2 / 2;
        if (n * 2 != n2) {
            throw new IllegalArgumentException("Must have pairs of keys and values");
        }
        ArrayList lattices = new ArrayList(n);
        ArrayList<Keyword> keys = new ArrayList<Keyword>(n);
        for (int i = 0; i < n; ++i) {
            Keyword k = Keyword.create(keysAndValues[2 * i]);
            if (k == null) {
                throw new IllegalArgumentException("Invalid key name");
            }
            ALattice v = (ALattice)keysAndValues[2 * i + 1];
            if (v == null) {
                throw new NullPointerException("null lattice");
            }
            lattices.add(v);
            keys.add(k);
        }
        return new KeyedLattice(lattices, keys);
    }

    @Override
    public AMap<Keyword, ?> merge(AMap<Keyword, ?> ownValue, AMap<Keyword, ?> otherValue) {
        if (ownValue == null) {
            if (this.checkForeign(otherValue)) {
                return otherValue;
            }
            return null;
        }
        if (otherValue == null) {
            return ownValue;
        }
        ADataStructure result = ownValue;
        int n = this.lattices.size();
        for (int i = 0; i < n; ++i) {
            Object b;
            Object a;
            Object m;
            ALattice<?> lattice = this.lattices.get(i);
            Keyword key = this.keys.get(i);
            if (!otherValue.containsKey(key) || Utils.equals(m = lattice.merge(a = ownValue.get(key), b = otherValue.get(key)), a)) continue;
            result = result.assoc(key, (ACell)m);
        }
        return result;
    }

    @Override
    public AMap<Keyword, ?> zero() {
        return Maps.empty();
    }

    @Override
    public boolean checkForeign(AMap<Keyword, ?> value) {
        return value instanceof AMap;
    }
}

