/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.fs.impl;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.prim.CVMLong;
import convex.lattice.fs.DLFSNode;
import convex.lattice.fs.DLFSProvider;
import convex.lattice.fs.DLFileSystem;
import convex.lattice.fs.DLPath;
import convex.lattice.fs.impl.DLDirectoryStream;
import convex.lattice.fs.impl.DLFileChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

public class DLFSLocal
extends DLFileSystem {
    AVector<ACell> rootNode;

    public DLFSLocal(DLFSProvider dlfsProvider, String uriPath, AVector<ACell> rootNode) {
        super(dlfsProvider, uriPath, DLFSNode.getUTime(rootNode));
        this.rootNode = rootNode;
    }

    public static DLFSLocal create(DLFSProvider provider) {
        return new DLFSLocal(provider, null, DLFSNode.createDirectory(CVMLong.ZERO));
    }

    @Override
    public AVector<ACell> getNode(DLPath path) {
        AVector<ACell> result = DLFSNode.navigate(this.rootNode, path);
        return result;
    }

    @Override
    protected DLDirectoryStream newDirectoryStream(DLPath dir, DirectoryStream.Filter<? super Path> filter) {
        AVector<ACell> result = DLFSNode.navigate(this.rootNode, dir);
        return DLDirectoryStream.create(dir, result);
    }

    @Override
    public SeekableByteChannel newByteChannel(DLPath path, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        path = path.normalize();
        return DLFileChannel.create(this, options, path);
    }

    @Override
    protected synchronized DLPath createDirectory(DLPath dir, FileAttribute<?>[] attrs) throws IOException {
        AString name = dir.getCVMFileName();
        if (name == null) {
            throw new FileAlreadyExistsException("/");
        }
        DLPath parent = dir.getParent();
        if (parent == null) {
            throw new FileAlreadyExistsException(dir.toString());
        }
        AVector<ACell> parentNode = DLFSNode.navigate(this.rootNode, parent);
        if (parentNode == null) {
            throw new FileNotFoundException(parent.toString());
        }
        if (DLFSNode.getDirectoryEntries(parentNode).containsKey(name)) {
            throw new FileAlreadyExistsException(dir.toString());
        }
        this.updateNode(dir, DLFSNode.createDirectory(this.getTimestamp()));
        return dir;
    }

    @Override
    public synchronized AVector<ACell> createFile(DLPath path) throws IOException {
        AString name = path.getCVMFileName();
        DLPath parent = (path = path.toAbsolutePath()).getParent();
        if (parent == null) {
            throw new FileAlreadyExistsException(path.toString());
        }
        AVector<ACell> parentNode = DLFSNode.navigate(this.rootNode, parent);
        if (parentNode == null) {
            throw new FileNotFoundException("Parent directory does not exist: " + parent.toString());
        }
        AVector<ACell> oldNode = DLFSNode.getDirectoryEntries(parentNode).get(name);
        if (oldNode != null && !DLFSNode.isTombstone(oldNode)) {
            throw new FileAlreadyExistsException(name.toString());
        }
        AVector<ACell> newNode = DLFSNode.createEmptyFile(this.getTimestamp());
        this.updateNode(path, newNode);
        return newNode;
    }

    @Override
    public synchronized void delete(DLPath path) throws IOException {
        if ((path = path.toAbsolutePath()).getNameCount() == 0) {
            throw new IOException("Can't delete DLFS Root node");
        }
        AVector<ACell> node = this.getNode(path);
        if (node == null) {
            throw new NoSuchFileException(path.toString());
        }
        Index<AString, AVector<ACell>> entries = DLFSNode.getDirectoryEntries(node);
        if (entries != null && !entries.isEmpty()) {
            throw new DirectoryNotEmptyException(path.toString());
        }
        this.updateNode(path, DLFSNode.createTombstone(this.getTimestamp()));
    }

    @Override
    public synchronized AVector<ACell> updateNode(DLPath dir, AVector<ACell> newNode) {
        this.rootNode = DLFSNode.updateNode(this.rootNode, dir, newNode, this.getTimestamp());
        return newNode;
    }

    @Override
    protected void checkAccess(DLPath path) throws IOException {
        AVector<ACell> node = DLFSNode.navigate(this.rootNode, path);
        if (node == null || DLFSNode.isTombstone(node)) {
            throw new NoSuchFileException(path.toString());
        }
    }

    @Override
    public Hash getRootHash() {
        return Cells.getHash(this.rootNode);
    }

    @Override
    public void merge(AVector<ACell> other) {
        AVector<ACell> merged = DLFSNode.merge(this.rootNode, other, this.getTimestamp());
        this.rootNode = merged;
    }

    @Override
    public DLFSLocal clone() {
        DLFSLocal result = new DLFSLocal(this.provider(), this.uriPath, this.rootNode);
        return result;
    }
}

